% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot_richness}
\alias{plot_richness}
\title{Plot alpha diversity, flexibly with ggplot2}
\usage{
plot_richness(physeq, x = "samples", color = NULL, shape = NULL,
  title = NULL, scales = "free_y", nrow = 1, shsi = NULL,
  measures = NULL, sortby = NULL)
}
\arguments{
\item{physeq}{(Required). \code{\link{phyloseq-class}}, or alternatively, 
an \code{\link{otu_table-class}}. The data about which you want to estimate.}

\item{x}{(Optional). A variable to map to the horizontal axis. The vertical
 axis will be mapped to the alpha diversity index/estimate
 and have units of total taxa, and/or index value (dimensionless).
 This parameter (\code{x}) can be either a character string indicating a
 variable in \code{sample_data} 
 (among the set returned by \code{sample_variables(physeq)} );
 or a custom supplied vector with length equal to the number of samples
 in the dataset (nsamples(physeq)).

 The default value is \code{"samples"}, which will map each sample's name
 to a separate horizontal position in the plot.}

\item{color}{(Optional). Default \code{NULL}. 
The sample variable to map to different colors.
Like \code{x}, this can be a single character string of the variable name in 
\code{sample_data} 
(among the set returned by \code{sample_variables(physeq)} );
or a custom supplied vector with length equal to the number of samples
in the dataset (nsamples(physeq)).
The color scheme is chosen automatically by \code{link{ggplot}},
but it can be modified afterward with an additional layer using
\code{\link[ggplot2]{scale_color_manual}}.}

\item{shape}{(Optional). Default \code{NULL}. The sample variable to map
to different shapes. Like \code{x} and \code{color},
this can be a single character string 
of the variable name in 
\code{sample_data} 
(among the set returned by \code{sample_variables(physeq)} );
or a custom supplied vector with length equal to the number of samples
in the dataset (nsamples(physeq)).
The shape scale is chosen automatically by \code{link{ggplot}},
but it can be modified afterward with an additional layer using
\code{\link[ggplot2]{scale_shape_manual}}.}

\item{title}{(Optional). Default \code{NULL}. Character string.
The main title for the graphic.}

\item{scales}{(Optional). Default \code{"free_y"}.
Whether to let vertical axis have free scale that adjusts to
the data in each panel.
This argument is passed to \code{\link[ggplot2]{facet_wrap}}.
If set to \code{"fixed"}, a single vertical scale will
be used in all panels. This can obscure values if the
\code{measures} argument includes both 
richness estimates and diversity indices, for example.}

\item{nrow}{(Optional). Default is \code{1},
meaning that all plot panels will be placed in a single row,
side-by-side. 
This argument is passed to \code{\link[ggplot2]{facet_wrap}}.
If \code{NULL}, the number of rows and columns will be 
chosen automatically (wrapped) based on the number of panels
and the size of the graphics device.}

\item{shsi}{(Deprecated). No longer supported. Instead see `measures` below.}

\item{measures}{(Optional). Default is \code{NULL}, meaning that
all available alpha-diversity measures will be included in plot panels.
Alternatively, you can specify one or more measures
as a character vector of measure names.
Values must be among those supported:
\code{c("Observed", "Chao1", "ACE", "Shannon", "Simpson", "InvSimpson", "Fisher")}.}

\item{sortby}{(Optional). A character string subset of \code{measures} argument.
Sort x-indices by the mean of one or more \code{measures},
if x-axis is mapped to a discrete variable.
Default is \code{NULL}, implying that a discrete-value horizontal axis
will use default sorting, usually alphabetic.}
}
\value{
A \code{\link{ggplot}} plot object summarizing
 the richness estimates, and their standard error.
}
\description{
There are many useful examples of alpha-diversity graphics in the
\href{http://joey711.github.io/phyloseq/plot_richness-examples}{phyloseq online tutorials}.
This function estimates a number of alpha-diversity metrics using the 
\code{\link{estimate_richness}} function,
and returns a \code{ggplot} plotting object. 
The plot generated by this function will include every sample
in \code{physeq}, but they can be further grouped on the horizontal axis
through the argument to \code{x}, 
and shaded according to the argument to \code{color} (see below).
You must use untrimmed, non-normalized count data for meaningful results, 
as many of these estimates are highly dependent on the number of singletons.
You can always trim the data later on if needed,
just not before using this function.
}
\details{
NOTE: Because this plotting function incorporates the output from 
 \code{\link{estimate_richness}}, the variable names of that output should
 not be used as \code{x} or \code{color} (even if it works, the resulting
 plot might be kindof strange, and not the intended behavior of this function).
 The following are the names you will want to avoid using in \code{x} or \code{color}:

\code{c("Observed", "Chao1", "ACE", "Shannon", "Simpson", "InvSimpson", "Fisher")}.
}
\examples{
## There are many more interesting examples at the phyloseq online tutorials.
## http://joey711.github.io/phyloseq/plot_richness-examples
data("soilrep")
plot_richness(soilrep, measures=c("InvSimpson", "Fisher"))
plot_richness(soilrep, "Treatment", "warmed", measures=c("Chao1", "ACE", "InvSimpson"), nrow=3)
data("GlobalPatterns")
plot_richness(GlobalPatterns, x="SampleType", measures=c("InvSimpson"))
plot_richness(GlobalPatterns, x="SampleType", measures=c("Chao1", "ACE", "InvSimpson"), nrow=3)
plot_richness(GlobalPatterns, x="SampleType", measures=c("Chao1", "ACE", "InvSimpson"), nrow=3, sortby = "Chao1")
}
\seealso{
\code{\link{estimate_richness}}
 
 \code{\link[vegan]{estimateR}}
 
 \code{\link[vegan]{diversity}}

There are many more interesting examples at the
\href{http://joey711.github.io/phyloseq/plot_richness-examples}{phyloseq online tutorials}.
}

