\name{getBackgroundFrequencies}
\alias{getBackgroundFrequencies}
\title{Get the four nucleotides background frequencies}
\usage{
  getBackgroundFrequencies(organism = "dm3",
    pseudo.count = 1, quick = FALSE)
}
\arguments{
  \item{organism}{either a name of the organisms for which
  the background should be compiled (supported names are "dm3", 
  "mm9" and "hg19"),
  a \code{BSgenome} object, \code{DNAStringSet}, or list of \code{DNAString} objects}

  \item{pseudo.count}{the number to which the frequencies
  sum up to, by default 1}

  \item{quick}{if to preform fitting on a reduced set of
  100 promoters. This will not give as good results but is
  much quicker than fitting to all the promoters (~10k).
  Usage of this parameter is recommended only for testing
  and rough estimates.}
}
\description{
  Estimate the background frequencies of A,C,G,T on a set
  of promoters from an organism
}
\examples{
\dontrun{
  getBackgroundFrequencies("dm3")
}
}
\author{
  Robert Stojnic, Diego Diez
}

