% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{breakpointgr2bedpe}
\alias{breakpointgr2bedpe}
\title{Converting breakpoint GRanges to BEDPE-like dataframe}
\usage{
breakpointgr2bedpe(gr)
}
\arguments{
\item{gr}{A GRanges object.}
}
\value{
A BEDPE-formatted data frame.
}
\description{
Converting breakpoint GRanges to BEDPE-like dataframe
}
\details{
\code{breakpointgr2bedpe} converts a breakpoint GRanges to a BEDPE-formatted
dataframe. The BEDPE format consists of two sets of genomic loci, optinal
columns of name, score, strand1, strand2 and any user-defined fields.
See \url{https://bedtools.readthedocs.io/en/latest/content/general-usage.html}
for more details of BEDPE format.
}
\examples{
#coverting a GRanges object to BEDPE-like dataframe
vcf.file <- system.file("extdata", "gridss.vcf", package = "StructuralVariantAnnotation")
vcf <- VariantAnnotation::readVcf(vcf.file, "hg19")
gr <- breakpointRanges(vcf)
breakpointgr2bedpe(gr)
}
