% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BreakpointGRanges.R
\name{breakpointgr2pairs}
\alias{breakpointgr2pairs}
\alias{pairs2breakpointgr}
\title{Converts a breakpoint GRanges object to a Pairs object}
\usage{
breakpointgr2pairs(
  bpgr,
  writeQualAsScore = TRUE,
  writeName = TRUE,
  bedpeName = NULL,
  firstInPair = NULL
)

pairs2breakpointgr(
  pairs,
  placeholderName = "bedpe",
  firstSuffix = "_1",
  secondSuffix = "_2",
  nameField = "name",
  renameScoreToQUAL = TRUE
)
}
\arguments{
\item{bpgr}{breakpoint GRanges object}

\item{writeQualAsScore}{write the breakpoint GRanges QUAL field as the score
fields for compatibility with BEDPE rtracklayer export}

\item{writeName}{write the breakpoint GRanges QUAL field as the score
fields for compatibility with BEDPE rtracklayer export}

\item{bedpeName}{function that returns the name to use for the breakpoint.
Defaults to the sourceId, name column, or row names (in that priority) of
the first breakend of each pair.}

\item{firstInPair}{function that returns TRUE for breakends that are considered
the first in the pair, and FALSE for the second in pair breakend. By default,
the first in the pair is the breakend with the lower ordinal in the breakpoint
GRanges object.}

\item{pairs}{a Pairs object consisting of two parallel genomic loci.}

\item{placeholderName}{prefix to use to ensure each entry has a unique ID.}

\item{firstSuffix}{first in pair name suffix to ensure breakend name uniqueness}

\item{secondSuffix}{second in pair name suffix to ensure breakend name uniqueness}

\item{nameField}{Fallback field for row names if the Pairs object does not contain any names.
BEDPE files loaded using rtracklayer use the "name" field.}

\item{renameScoreToQUAL}{renames the 'score' column to 'QUAL'.
Performing this rename results in a consistent variant quality score column
name for variant loaded from BEDPE and VCF.}
}
\value{
Pairs GRanges object suitable for export to BEDPE by rtracklayer

Breakpoint GRanges object.
}
\description{
Converts a breakpoint GRanges object to a Pairs object

Converts a BEDPE Pairs containing pairs of GRanges loaded using to a breakpoint GRanges object.
}
\details{
Breakpoint-level column names will override breakend-level column names.
}
\examples{
vcf.file <- system.file("extdata", "gridss.vcf", package = "StructuralVariantAnnotation")
bpgr <- breakpointRanges(VariantAnnotation::readVcf(vcf.file))
pairgr <- breakpointgr2pairs(bpgr)
rtracklayer::export(pairgr, con="example.bedpe")
bedpe.file <- system.file("extdata", "gridss.bedpe", package = "StructuralVariantAnnotation")
bedpe.pairs <- rtracklayer::import(bedpe.file)
bedpe.bpgr <- pairs2breakpointgr(bedpe.pairs)
}
