% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gafs.R
\name{gafs_initial}
\alias{gafs_initial}
\alias{gafs_lrSelection}
\alias{gafs_rwSelection}
\alias{gafs_tourSelection}
\alias{gafs_uCrossover}
\alias{gafs_spCrossover}
\alias{gafs_raMutation}
\alias{caretGA}
\alias{rfGA}
\alias{treebagGA}
\alias{gafs_nlrSelection}
\title{Ancillary genetic algorithm functions}
\usage{
gafs_initial(vars, popSize, ...)

gafs_lrSelection(population, fitness, r = NULL, q = NULL, ...)

gafs_spCrossover(population, fitness, parents, ...)

gafs_raMutation(population, parent, ...)

gafs_nlrSelection(population, fitness, q = 0.25, ...)

gafs_rwSelection(population, fitness, ...)

gafs_tourSelection(population, fitness, k = 3, ...)

gafs_uCrossover(population, parents, ...)
}
\arguments{
\item{vars}{number of possible predictors}

\item{popSize}{the population size passed into \code{\link{gafs}}}

\item{\dots}{not currently used}

\item{population}{a binary matrix of the current subsets with predictors in
columns and individuals in rows}

\item{fitness}{a vector of fitness values}

\item{r, q, k}{tuning parameters for the specific selection operator}

\item{parent, parents}{integer(s) for which chromosomes are altered}
}
\value{
The return value depends on the function.
}
\description{
Built-in functions related to genetic algorithms

These functions are used with the \code{functions} argument of the
\code{\link{gafsControl}} function. More information on the details of these
functions are at \url{http://topepo.github.io/caret/feature-selection-using-genetic-algorithms.html}.

Most of the \code{gafs_*} functions are based on those from the GA package
by Luca Scrucca. These functions here are small re-writes to work outside of
the GA package.

The objects \code{caretGA}, \code{rfGA} and \code{treebagGA} are example
lists that can be used with the \code{functions} argument of
\code{\link{gafsControl}}.

In the case of \code{caretGA}, the \code{...} structure of
\code{\link{gafs}} passes through to the model fitting routine. As a
consequence, the \code{\link{train}} function can easily be accessed by
passing important arguments belonging to \code{\link{train}} to
\code{\link{gafs}}. See the examples below. By default, using \code{caretGA}
will used the resampled performance estimates produced by
\code{\link{train}} as the internal estimate of fitness.

For \code{rfGA} and \code{treebagGA}, the \code{randomForest} and
\code{bagging} functions are used directly (i.e. \code{\link{train}} is not
used). Arguments to either of these functions can also be passed to them
though the \code{\link{gafs}} call (see examples below). For these two
functions, the internal fitness is estimated using the out-of-bag estimates
naturally produced by those functions. While faster, this limits the user to
accuracy or Kappa (for classification) and RMSE and R-squared (for
regression).
}
\examples{

pop <- gafs_initial(vars = 10, popSize = 10)
pop

gafs_lrSelection(population = pop, fitness = 1:10)

gafs_spCrossover(population = pop, fitness = 1:10, parents = 1:2)


\dontrun{
## Hypothetical examples
lda_ga <- gafs(x = predictors,
               y = classes,
               gafsControl = gafsControl(functions = caretGA),
               ## now pass arguments to `train`
               method = "lda",
               metric = "Accuracy"
               trControl = trainControl(method = "cv", classProbs = TRUE))

rf_ga <- gafs(x = predictors,
              y = classes,
              gafsControl = gafsControl(functions = rfGA),
              ## these are arguments to `randomForest`
              ntree = 1000,
              importance = TRUE)
	}


}
\references{
Scrucca L (2013). GA: A Package for Genetic Algorithms in R.
Journal of Statistical Software, 53(4), 1-37.

\url{cran.r-project.org/web/packages/GA/}

\url{http://topepo.github.io/caret/feature-selection-using-genetic-algorithms.html}
}
\seealso{
\code{\link{gafs}}, \code{\link{gafsControl}}
}
\author{
Luca Scrucca, \code{gafs_initial}, \code{caretGA}, \code{rfGA} and
\code{treebagGA} by Max Kuhn
}
