% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{verb-DELETE}
\alias{verb-DELETE}
\title{HTTP verb info: DELETE}
\description{
The DELETE method deletes the specified resource.
}
\section{The DELETE method}{

The DELETE method requests that the origin server remove the
association between the target resource and its current
functionality.  In effect, this method is similar to the rm command
in UNIX: it expresses a deletion operation on the URI mapping of the
origin server rather than an expectation that the previously
associated information be deleted.

See \url{https://tools.ietf.org/html/rfc7231#section-4.3.5} for further
details.
}

\examples{
\dontrun{
x <- HttpClient$new(url = "https://httpbin.org")
x$delete(path = 'delete')
}

}
\references{
\url{https://tools.ietf.org/html/rfc7231#section-4.3.5}
}
\seealso{
\link{crul-package}

Other verbs: \code{\link{verb-GET}},
  \code{\link{verb-HEAD}}, \code{\link{verb-PATCH}},
  \code{\link{verb-POST}}, \code{\link{verb-PUT}}
}
\concept{verbs}
