% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_degree_distribution.R
\name{get_degree_distribution}
\alias{get_degree_distribution}
\title{Get total degree distribution data for a graph}
\usage{
get_degree_distribution(graph, mode = "total")
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{mode}{using \code{total} (the default), degree considered for each node
will be the total degree. With \verb{in} and \code{out} the degree used
will be the in-degree and out-degree, respectively.}
}
\value{
A data frame with degree frequencies.
}
\description{
Get degree distribution data for a graph. Graph degree is represented as a
frequency of total degree values over all nodes in the graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get the total degree
# distribution for the graph
graph \%>\%
  get_degree_distribution(
    mode = "total")

}
