% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_ANOVA.R
\name{rank_epsilon_squared}
\alias{rank_epsilon_squared}
\alias{rank_eta_squared}
\alias{kendalls_w}
\title{Effect Size for Rank Based ANOVA}
\usage{
rank_epsilon_squared(
  x,
  groups,
  data = NULL,
  ci = 0.95,
  alternative = "greater",
  iterations = 200,
  verbose = TRUE,
  ...
)

rank_eta_squared(
  x,
  groups,
  data = NULL,
  ci = 0.95,
  alternative = "greater",
  iterations = 200,
  verbose = TRUE,
  ...
)

kendalls_w(
  x,
  groups,
  blocks,
  data = NULL,
  blocks_on_rows = TRUE,
  ci = 0.95,
  alternative = "greater",
  iterations = 200,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{Can be one of:
\itemize{
\item A numeric or ordered vector, or a character name of one in \code{data}.
\item A list of vectors (for \code{rank_eta/epsilon_squared()}).
\item A matrix of \verb{blocks x groups} (for \code{kendalls_w()}) (or \verb{groups x blocks}
if \code{blocks_on_rows = FALSE}). See details for the \code{blocks} and \code{groups}
terminology used here.
\item A formula in the form of:
\itemize{
\item \code{DV ~ groups} for \code{rank_eta/epsilon_squared()}.
\item \code{DV ~ groups | blocks} for \code{kendalls_w()} (See details for the
\code{blocks} and \code{groups} terminology used here).
}
}}

\item{groups, blocks}{A factor vector giving the group / block for the
corresponding elements of \code{x}, or a character name of one in \code{data}.
Ignored if \code{x} is not a vector.}

\item{data}{An optional data frame containing the variables.}

\item{ci}{Confidence Interval (CI) level}

\item{alternative}{a character string specifying the alternative hypothesis;
Controls the type of CI returned: \code{"two.sided"} (default, two-sided CI),
\code{"greater"} or \code{"less"} (one-sided CI). Partial matching is allowed (e.g.,
\code{"g"}, \code{"l"}, \code{"two"}...). See \emph{One-Sided CIs} in \link{effectsize_CIs}.}

\item{iterations}{The number of bootstrap replicates for computing confidence
intervals. Only applies when \code{ci} is not \code{NULL}.}

\item{verbose}{Toggle warnings and messages on or off.}

\item{...}{Arguments passed to or from other methods. When \code{x} is a formula,
these can be \code{subset} and \code{na.action}.}

\item{blocks_on_rows}{Are blocks on rows (\code{TRUE}) or columns (\code{FALSE}).}
}
\value{
A data frame with the effect size and its CI.
}
\description{
Compute rank epsilon squared (\eqn{E^2_R}) or rank eta squared
(\eqn{\eta^2_H}) (to accompany \code{\link[stats:kruskal.test]{stats::kruskal.test()}}), and Kendall's \emph{W}
(to accompany \code{\link[stats:friedman.test]{stats::friedman.test()}}) effect sizes for non-parametric (rank
sum) one-way ANOVAs.
}
\details{
The rank epsilon squared and rank eta squared are appropriate for
non-parametric tests of differences between 2 or more samples (a rank based
ANOVA). See \link[stats:kruskal.test]{stats::kruskal.test}. Values range from 0 to 1, with larger
values indicating larger differences between groups.
\cr\cr
Kendall's \emph{W} is appropriate for non-parametric tests of differences between
2 or more dependent samples (a rank based rmANOVA), where each \code{group} (e.g.,
experimental condition) was measured for each \code{block} (e.g., subject). This
measure is also common as a measure of reliability of the rankings of the
\code{groups} between raters (\code{blocks}). See \link[stats:friedman.test]{stats::friedman.test}. Values range
from 0 to 1, with larger values indicating larger differences between groups
/ higher agreement between raters.
}
\section{Confidence (Compatibility) Intervals (CIs)}{
Confidence intervals for \eqn{E^2_R}, \eqn{\eta^2_H}, and Kendall's \emph{W} are
estimated using the bootstrap method (using the \code{{boot}} package).
}

\section{Ties}{
When tied values occur, they are each given the average of the ranks that
would have been given had no ties occurred. This results in an effect size of
reduced magnitude. A correction has been applied for Kendall's \emph{W}.
}

\section{CIs and Significance Tests}{
"Confidence intervals on measures of effect size convey all the information
in a hypothesis test, and more." (Steiger, 2004). Confidence (compatibility)
intervals and p values are complementary summaries of parameter uncertainty
given the observed data. A dichotomous hypothesis test could be performed
with either a CI or a p value. The 100 (1 - \eqn{\alpha})\% confidence
interval contains all of the parameter values for which \emph{p} > \eqn{\alpha}
for the current data and model. For example, a 95\% confidence interval
contains all of the values for which p > .05.
\cr\cr
Note that a confidence interval including 0 \emph{does not} indicate that the null
(no effect) is true. Rather, it suggests that the observed data together with
the model and its assumptions combined do not provided clear evidence against
a parameter value of 0 (same as with any other value in the interval), with
the level of this evidence defined by the chosen \eqn{\alpha} level (Rafi &
Greenland, 2020; Schweder & Hjort, 2016; Xie & Singh, 2013). To infer no
effect, additional judgments about what parameter values are "close enough"
to 0 to be negligible are needed ("equivalence testing"; Bauer & Kiesser,
1996).
}

\section{Bootstrapped CIs}{
Some effect sizes are directionless--they do have a minimum value that would
be interpreted as "no effect", but they cannot cross it. For example, a null
value of \link[=kendalls_w]{Kendall's W} is 0, indicating no difference between
groups, but it can never have a negative value. Same goes for
\link[=cohens_u2]{U2} and \link[=p_overlap]{Overlap}: the null value of \eqn{U_2} is
0.5, but it can never be smaller than 0.5; am \emph{Overlap} of 1 means "full
overlap" (no difference), but it cannot be larger than 1.
\cr\cr
When bootstrapping CIs for such effect sizes, the bounds of the CIs will
never cross (and often will never cover) the null. Therefore, these CIs
should not be used for statistical inference.
}

\section{Plotting with \code{see}}{

The \code{see} package contains relevant plotting functions. See the \href{https://easystats.github.io/see/articles/effectsize.html}{plotting vignette in the \code{see} package}.
}

\examples{
\donttest{
# Rank Eta/Epsilon Squared
# ========================

rank_eta_squared(mpg ~ cyl, data = mtcars)

rank_epsilon_squared(mpg ~ cyl, data = mtcars)



# Kendall's W
# ===========
dat <- data.frame(
  cond = c("A", "B", "A", "B", "A", "B"),
  ID = c("L", "L", "M", "M", "H", "H"),
  y = c(44.56, 28.22, 24, 28.78, 24.56, 18.78)
)
(W <- kendalls_w(y ~ cond | ID, data = dat, verbose = FALSE))

interpret_kendalls_w(0.11)
interpret(W, rules = "landis1977")
}

}
\references{
\itemize{
\item Kendall, M.G. (1948) Rank correlation methods. London: Griffin.
\item Tomczak, M., & Tomczak, E. (2014). The need to report effect size estimates
revisited. An overview of some recommended measures of effect size. Trends in
sport sciences, 1(21), 19-25.
}
}
\seealso{
Other rank-based effect sizes: 
\code{\link{p_superiority}()},
\code{\link{rank_biserial}()}

Other effect sizes for ANOVAs: 
\code{\link{eta_squared}()}
}
\concept{effect sizes for ANOVAs}
\concept{rank-based effect sizes}
