% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{plot.flextable}
\alias{plot.flextable}
\title{plot a flextable}
\usage{
\method{plot}{flextable}(x, zoom = 2, expand = 2, ...)
}
\arguments{
\item{x}{a flextable object}

\item{zoom, expand}{parameters used by \code{webshot} function.}

\item{...}{additional parameters sent to \code{\link[=as_raster]{as_raster()}} function}
}
\description{
save a flextable as an image and display the
result in a new R graphics window.
}
\note{
This function requires packages: webshot and magick.
}
\examples{
ftab <- flextable( head( mtcars ) )
ftab <- autofit(ftab)
\dontrun{
if( require("webshot") ){
  plot(ftab)
}
}
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()}
}
\concept{flextable print function}
