% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizor.R
\name{summarizor}
\alias{summarizor}
\title{data summary preparation}
\usage{
summarizor(x, by = character(), overall_label = NULL)
}
\arguments{
\item{x}{dataset}

\item{by}{columns names to be used as grouping columns}

\item{overall_label}{label to use as overall label}
}
\description{
It performs a univariate statistical analysis of a dataset
by group and formats the results so that they can be used with
the \code{\link[=tabulator]{tabulator()}} function.
}
\note{
This is very first version of the function; be aware it
can evolve or change.
}
\section{Illustrations}{

ft_1 appears as:

\if{html}{\figure{fig_summarizor_1.png}{options: width="500"}}

ft_2 appears as:

\if{html}{\figure{fig_summarizor_2.png}{options: width="500"}}
}

\examples{
z <- summarizor(CO2[-c(1, 4)],
  by = "Treatment",
  overall_label = "Overall"
)


# version 1 ----
tab_1 <- tabulator(
  x = z,
  rows = c("variable", "stat"),
  columns = "Treatment",
  blah = as_paragraph(
    as_chunk(
      fmt_2stats(
        num1 = stat, num2 = value, cts = cts, pcts = percent
      )
    )
  )
)

ft_1 <- as_flextable(tab_1, separate_with = "variable")
ft_1

# version 2 ----
n_format <- function(n, percent) {
  z <- character(length = length(n))
  wcts <- !is.na(n)
  z[wcts] <- sprintf("\%.0f (\%.01f \%\%)", n[wcts], percent[wcts] * 100)
  z
}
stat_format <- function(value) {
  z <- character(length = length(value))
  wnum <- !is.na(value)
  z[wnum] <- sprintf("\%.01f", value[wnum])
  z
}

tab_2 <- tabulator(z,
  rows = c("variable", "stat"),
  columns = "Treatment",
  `Est.` = as_paragraph(as_chunk(value)),
  `N` = as_paragraph(as_chunk(n_format(cts, percent)))
)

ft_2 <- as_flextable(tab_2, separate_with = "variable")
ft_2
}
\seealso{
\code{\link[=fmt_2stats]{fmt_2stats()}}
}
