% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.R
\name{is_tree}
\alias{is_tree}
\title{Check if object is S3 class git_tree}
\usage{
is_tree(object)
}
\arguments{
\item{object}{Check if object is S3 class git_tree}
}
\value{
TRUE if object is S3 class git_tree, else FALSE
}
\description{
Check if object is S3 class git_tree
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name = "Alice", user.email = "alice@example.org")

## Commit a text file
writeLines("Hello world!", file.path(path, "example.txt"))
add(repo, "example.txt")
commit_1 <- commit(repo, "First commit message")
tree_1 <- tree(commit_1)

## Check if tree
is_tree(commit_1)
is_tree(tree_1)
}
}
\keyword{methods}
