% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{norm_coords}
\alias{norm_coords}
\alias{layout.norm}
\title{Normalize coordinates for plotting graphs}
\usage{
norm_coords(layout, xmin = -1, xmax = 1, ymin = -1, ymax = 1,
  zmin = -1, zmax = 1)
}
\arguments{
\item{layout}{A matrix with two or three columns, the layout to normalize.}

\item{xmin, xmax}{The limits for the first coordinate, if one of them or both
are \code{NULL} then no normalization is performed along this direction.}

\item{ymin, ymax}{The limits for the second coordinate, if one of them or
both are \code{NULL} then no normalization is performed along this
direction.}

\item{zmin, zmax}{The limits for the third coordinate, if one of them or both
are \code{NULL} then no normalization is performed along this direction.}
}
\value{
A numeric matrix with at the same dimension as \code{layout}.
}
\description{
Rescale coordinates linearly to be within given bounds.
}
\details{
\code{norm_coords} normalizes a layout, it linearly transforms each
coordinate separately to fit into the given limits.
}
\seealso{
Other graph layouts: \code{\link{add_layout_}},
  \code{\link{component_wise}},
  \code{\link{layout_as_bipartite}},
  \code{\link{layout_as_star}},
  \code{\link{layout_as_tree}},
  \code{\link{layout_in_circle}},
  \code{\link{layout_nicely}},
  \code{\link{layout_on_grid}},
  \code{\link{layout_on_sphere}},
  \code{\link{layout_randomly}},
  \code{\link{layout_with_dh}},
  \code{\link{layout_with_fr}},
  \code{\link{layout_with_gem}},
  \code{\link{layout_with_graphopt}},
  \code{\link{layout_with_kk}},
  \code{\link{layout_with_lgl}},
  \code{\link{layout_with_mds}},
  \code{\link{layout_with_sugiyama}},
  \code{\link{layout_}}, \code{\link{merge_coords}},
  \code{\link{normalize}}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\keyword{graphs}
