% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community.R
\name{cluster_walktrap}
\alias{cluster_walktrap}
\alias{walktrap.community}
\title{Community strucure via short random walks}
\usage{
cluster_walktrap(
  graph,
  weights = E(graph)$weight,
  steps = 4,
  merges = TRUE,
  modularity = TRUE,
  membership = TRUE
)
}
\arguments{
\item{graph}{The input graph, edge directions are ignored in directed
graphs.}

\item{weights}{The edge weights. Larger edge weights increase the
probability that an edge is selected by the random walker. In other
words, larger edge weights correspond to stronger connections.}

\item{steps}{The length of the random walks to perform.}

\item{merges}{Logical scalar, whether to include the merge matrix in the
result.}

\item{modularity}{Logical scalar, whether to include the vector of the
modularity scores in the result. If the \code{membership} argument is true,
then it will be always calculated.}

\item{membership}{Logical scalar, whether to calculate the membership vector
for the split corresponding to the highest modularity value.}
}
\value{
\code{cluster_walktrap} returns a \code{\link{communities}}
object, please see the \code{\link{communities}} manual page for details.
}
\description{
This function tries to find densely connected subgraphs, also called
communities in a graph via random walks. The idea is that short random walks
tend to stay in the same community.
}
\details{
This function is the implementation of the Walktrap community finding
algorithm, see Pascal Pons, Matthieu Latapy: Computing communities in large
networks using random walks, http://arxiv.org/abs/physics/0512106
}
\examples{

g <- make_full_graph(5) \%du\% make_full_graph(5) \%du\% make_full_graph(5)
g <- add_edges(g, c(1,6, 1,11, 6, 11))
cluster_walktrap(g)

}
\references{
Pascal Pons, Matthieu Latapy: Computing communities in large
networks using random walks, http://arxiv.org/abs/physics/0512106
}
\seealso{
See \code{\link{communities}} on getting the actual membership
vector, merge matrix, modularity score, etc.

\code{\link{modularity}} and \code{\link{cluster_fast_greedy}},
\code{\link{cluster_spinglass}},
\code{\link{cluster_leading_eigen}},
\code{\link{cluster_edge_betweenness}} for other community detection
methods.
}
\author{
Pascal Pons (\url{http://psl.pons.free.fr/}) and Gabor Csardi
\email{csardi.gabor@gmail.com} for the R and igraph interface
}
\keyword{graphs}
