% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentenceParse.R
\name{sentenceParse}
\alias{sentenceParse}
\title{Parse text into sentences}
\usage{
sentenceParse(text, docId = "create")
}
\arguments{
\item{text}{Character vector to be parsed into sentences}

\item{docId}{A vector of document IDs with length equal to the length of \code{text}.  If \code{docId == "create"} then doc IDs will be created as an index from 1 to \code{n}, where \code{n} is the length of \code{text}.}
}
\value{
A data frame with 3 columns and \code{n} rows, where \code{n} is the number of sentences found by the routine.  Column 1: \code{docId} document id for the sentence. Column 2: \code{sentenceId} sentence id for the sentence.  Column 3: \code{sentence} the sentences found in the routine.
}
\description{
Parse the elements of a character vector into a dataframe of sentences with additional identifiers.
}
\examples{
sentenceParse("Bill is trying to earn a Ph.D.", "You have to have a 5.0 GPA.")
sentenceParse(c("Bill is trying to earn a Ph.D.", "You have to have a 5.0 GPA."),
               docId=c("d1","d2"))
}
