% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R
\name{linters}
\alias{linters}
\title{Available linters}
\description{
A variety of linters are available in \pkg{lintr}. The most popular ones are readily
accessible through \code{\link[=default_linters]{default_linters()}}.

Within a \code{\link[=lint]{lint()}} function call, the linters in use are initialized with the provided
arguments and fed with the source file (provided by \code{\link[=get_source_expressions]{get_source_expressions()}}).

A data frame of all available linters can be retrieved using \code{\link[=available_linters]{available_linters()}}.
Documentation for linters is structured into tags to allow for easier discovery;
see also \code{\link[=available_tags]{available_tags()}}.
}
\section{Tags}{
The following tags exist:
\itemize{
\item{\link[=best_practices_linters]{best_practices} (50 linters)}
\item{\link[=common_mistakes_linters]{common_mistakes} (7 linters)}
\item{\link[=configurable_linters]{configurable} (29 linters)}
\item{\link[=consistency_linters]{consistency} (18 linters)}
\item{\link[=correctness_linters]{correctness} (7 linters)}
\item{\link[=default_linters]{default} (25 linters)}
\item{\link[=deprecated_linters]{deprecated} (8 linters)}
\item{\link[=efficiency_linters]{efficiency} (23 linters)}
\item{\link[=executing_linters]{executing} (5 linters)}
\item{\link[=package_development_linters]{package_development} (14 linters)}
\item{\link[=readability_linters]{readability} (47 linters)}
\item{\link[=robustness_linters]{robustness} (14 linters)}
\item{\link[=style_linters]{style} (34 linters)}
}
}
\section{Linters}{
The following linters exist:
\itemize{
\item{\code{\link{absolute_path_linter}} (tags: best_practices, configurable, robustness)}
\item{\code{\link{any_duplicated_linter}} (tags: best_practices, efficiency)}
\item{\code{\link{any_is_na_linter}} (tags: best_practices, efficiency)}
\item{\code{\link{assignment_linter}} (tags: configurable, consistency, default, style)}
\item{\code{\link{backport_linter}} (tags: configurable, package_development, robustness)}
\item{\code{\link{boolean_arithmetic_linter}} (tags: best_practices, efficiency, readability)}
\item{\code{\link{brace_linter}} (tags: configurable, default, readability, style)}
\item{\code{\link{class_equals_linter}} (tags: best_practices, consistency, robustness)}
\item{\code{\link{commas_linter}} (tags: default, readability, style)}
\item{\code{\link{commented_code_linter}} (tags: best_practices, default, readability, style)}
\item{\code{\link{condition_message_linter}} (tags: best_practices, consistency)}
\item{\code{\link{conjunct_test_linter}} (tags: best_practices, configurable, package_development, readability)}
\item{\code{\link{consecutive_assertion_linter}} (tags: consistency, readability, style)}
\item{\code{\link{cyclocomp_linter}} (tags: best_practices, configurable, default, readability, style)}
\item{\code{\link{duplicate_argument_linter}} (tags: common_mistakes, configurable, correctness)}
\item{\code{\link{empty_assignment_linter}} (tags: best_practices, readability)}
\item{\code{\link{equals_na_linter}} (tags: common_mistakes, correctness, default, robustness)}
\item{\code{\link{expect_comparison_linter}} (tags: best_practices, package_development)}
\item{\code{\link{expect_identical_linter}} (tags: package_development)}
\item{\code{\link{expect_length_linter}} (tags: best_practices, package_development, readability)}
\item{\code{\link{expect_named_linter}} (tags: best_practices, package_development, readability)}
\item{\code{\link{expect_not_linter}} (tags: best_practices, package_development, readability)}
\item{\code{\link{expect_null_linter}} (tags: best_practices, package_development)}
\item{\code{\link{expect_s3_class_linter}} (tags: best_practices, package_development)}
\item{\code{\link{expect_s4_class_linter}} (tags: best_practices, package_development)}
\item{\code{\link{expect_true_false_linter}} (tags: best_practices, package_development, readability)}
\item{\code{\link{expect_type_linter}} (tags: best_practices, package_development)}
\item{\code{\link{extraction_operator_linter}} (tags: best_practices, style)}
\item{\code{\link{fixed_regex_linter}} (tags: best_practices, efficiency, readability)}
\item{\code{\link{for_loop_index_linter}} (tags: best_practices, readability, robustness)}
\item{\code{\link{function_argument_linter}} (tags: best_practices, consistency, style)}
\item{\code{\link{function_left_parentheses_linter}} (tags: default, readability, style)}
\item{\code{\link{function_return_linter}} (tags: best_practices, readability)}
\item{\code{\link{ifelse_censor_linter}} (tags: best_practices, efficiency)}
\item{\code{\link{implicit_assignment_linter}} (tags: best_practices, configurable, readability, style)}
\item{\code{\link{implicit_integer_linter}} (tags: best_practices, configurable, consistency, style)}
\item{\code{\link{indentation_linter}} (tags: configurable, default, readability, style)}
\item{\code{\link{infix_spaces_linter}} (tags: configurable, default, readability, style)}
\item{\code{\link{inner_combine_linter}} (tags: consistency, efficiency, readability)}
\item{\code{\link{is_numeric_linter}} (tags: best_practices, consistency, readability)}
\item{\code{\link{lengths_linter}} (tags: best_practices, efficiency, readability)}
\item{\code{\link{line_length_linter}} (tags: configurable, default, readability, style)}
\item{\code{\link{literal_coercion_linter}} (tags: best_practices, consistency, efficiency)}
\item{\code{\link{matrix_apply_linter}} (tags: efficiency, readability)}
\item{\code{\link{missing_argument_linter}} (tags: common_mistakes, configurable, correctness)}
\item{\code{\link{missing_package_linter}} (tags: common_mistakes, robustness)}
\item{\code{\link{namespace_linter}} (tags: configurable, correctness, executing, robustness)}
\item{\code{\link{nested_ifelse_linter}} (tags: efficiency, readability)}
\item{\code{\link{nonportable_path_linter}} (tags: best_practices, configurable, robustness)}
\item{\code{\link{numeric_leading_zero_linter}} (tags: consistency, readability, style)}
\item{\code{\link{object_length_linter}} (tags: configurable, default, executing, readability, style)}
\item{\code{\link{object_name_linter}} (tags: configurable, consistency, default, executing, style)}
\item{\code{\link{object_usage_linter}} (tags: configurable, correctness, default, executing, readability, style)}
\item{\code{\link{outer_negation_linter}} (tags: best_practices, efficiency, readability)}
\item{\code{\link{package_hooks_linter}} (tags: correctness, package_development, style)}
\item{\code{\link{paren_body_linter}} (tags: default, readability, style)}
\item{\code{\link{paste_linter}} (tags: best_practices, configurable, consistency)}
\item{\code{\link{pipe_call_linter}} (tags: readability, style)}
\item{\code{\link{pipe_continuation_linter}} (tags: default, readability, style)}
\item{\code{\link{quotes_linter}} (tags: configurable, consistency, default, readability, style)}
\item{\code{\link{redundant_equals_linter}} (tags: best_practices, common_mistakes, efficiency, readability)}
\item{\code{\link{redundant_ifelse_linter}} (tags: best_practices, configurable, consistency, efficiency)}
\item{\code{\link{regex_subset_linter}} (tags: best_practices, efficiency)}
\item{\code{\link{routine_registration_linter}} (tags: best_practices, efficiency, robustness)}
\item{\code{\link{semicolon_linter}} (tags: configurable, default, readability, style)}
\item{\code{\link{seq_linter}} (tags: best_practices, consistency, default, efficiency, robustness)}
\item{\code{\link{sort_linter}} (tags: best_practices, efficiency, readability)}
\item{\code{\link{spaces_inside_linter}} (tags: default, readability, style)}
\item{\code{\link{spaces_left_parentheses_linter}} (tags: default, readability, style)}
\item{\code{\link{sprintf_linter}} (tags: common_mistakes, correctness)}
\item{\code{\link{string_boundary_linter}} (tags: configurable, efficiency, readability)}
\item{\code{\link{strings_as_factors_linter}} (tags: robustness)}
\item{\code{\link{system_file_linter}} (tags: best_practices, consistency, readability)}
\item{\code{\link{T_and_F_symbol_linter}} (tags: best_practices, consistency, default, readability, robustness, style)}
\item{\code{\link{todo_comment_linter}} (tags: configurable, style)}
\item{\code{\link{trailing_blank_lines_linter}} (tags: default, style)}
\item{\code{\link{trailing_whitespace_linter}} (tags: configurable, default, style)}
\item{\code{\link{undesirable_function_linter}} (tags: best_practices, configurable, efficiency, robustness, style)}
\item{\code{\link{undesirable_operator_linter}} (tags: best_practices, configurable, efficiency, robustness, style)}
\item{\code{\link{unnecessary_concatenation_linter}} (tags: configurable, efficiency, readability, style)}
\item{\code{\link{unnecessary_lambda_linter}} (tags: best_practices, efficiency, readability)}
\item{\code{\link{unnecessary_nested_if_linter}} (tags: best_practices, readability)}
\item{\code{\link{unnecessary_placeholder_linter}} (tags: best_practices, readability)}
\item{\code{\link{unreachable_code_linter}} (tags: best_practices, readability)}
\item{\code{\link{unused_import_linter}} (tags: best_practices, common_mistakes, configurable, executing)}
\item{\code{\link{vector_logic_linter}} (tags: best_practices, default, efficiency)}
\item{\code{\link{whitespace_linter}} (tags: consistency, default, style)}
\item{\code{\link{yoda_test_linter}} (tags: best_practices, package_development, readability)}
}
}
