% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops-%m+%.r
\name{\%m+\%}
\alias{\%m+\%}
\alias{\%m+\%,ANY,ANY-method}
\alias{\%m+\%,ANY,Duration-method}
\alias{\%m+\%,ANY,Interval-method}
\alias{\%m+\%,ANY,Period-method}
\alias{\%m+\%,Duration,ANY-method}
\alias{\%m+\%,Interval,ANY-method}
\alias{\%m+\%,Period,ANY-method}
\alias{\%m-\%}
\alias{\%m-\%,ANY,ANY-method}
\alias{\%m-\%,ANY,Duration-method}
\alias{\%m-\%,ANY,Interval-method}
\alias{\%m-\%,ANY,Period-method}
\alias{\%m-\%,Duration,ANY-method}
\alias{\%m-\%,Interval,ANY-method}
\alias{\%m-\%,Period,ANY-method}
\alias{add_with_rollback}
\alias{m+}
\alias{m-}
\title{Add and subtract months to a date without exceeding the last day of the new month}
\usage{
e1 \%m+\% e2

add_with_rollback(e1, e2, roll_to_first = FALSE, preserve_hms = TRUE)
}
\arguments{
\item{e1}{A period or a date-time object of class \code{\link{POSIXlt}}, \code{\link{POSIXct}} 
or \code{\link{Date}}.}

\item{e2}{A period or a date-time object of class \code{\link{POSIXlt}}, \code{\link{POSIXct}} 
or \code{\link{Date}}. Note that one of e1 and e2 must be a period and the other a 
date-time object.}

\item{roll_to_first}{rollback to the first day of the month instead of the
last day of the previous month (passed to \code{\link{rollback}})}

\item{preserve_hms}{retains the same hour, minute, and second information? If
FALSE, the new date will be at 00:00:00 (passed to \code{\link{rollback}})}
}
\value{
A date-time object of class POSIXlt, POSIXct or Date
}
\description{
Adding months frustrates basic arithmetic because consecutive months have
different lengths. With other elements, it is helpful for arithmetic to
perform automatic roll over. For example, 12:00:00 + 61 seconds becomes
12:01:01. However, people often prefer that this behavior NOT occur with
months. For example, we sometimes want January 31 + 1 month = February 28 and
not March 3. \%m+\% performs this type of arithmetic. Date \%m+\% months(n)
always returns a date in the nth month after Date. If the new date would
usually spill over into the n + 1th month, \%m+\% will return the last day of
the nth month (\code{\link{rollback}}. Date \%m-\% months(n) always returns a
date in the nth month before Date.
 
\%m+\% and \%m-\% handle periods with components less than a month by first
adding/substracting months and then performing usual arithmetics with smaller
units.

\code{add_with_rollback} provides additional functionality to \%m+\% and
\%m-\%. It allows rollback to first day of the month instead of the last day
of the previous month and controls whether HMS component of the end date is
preserved or not.
}
\details{
\%m+\% and \%m-\% should be used with caution as they are not one-to-one
operations and results for either will be sensitive to the order of
operations.
}
\examples{
jan <- ymd_hms("2010-01-31 03:04:05")
# "2010-01-31 03:04:05 UTC"
jan + months(1:3) # Feb 31 and April 31 returned as NA
# NA "2010-03-31 03:04:05 UTC" NA
jan \%m+\% months(1:3) # No rollover
# "2010-02-28 03:04:05 UTC" "2010-03-31 03:04:05 UTC" "2010-04-30 03:04:05 UTC"

leap <- ymd("2012-02-29")
"2012-02-29 UTC"
leap \%m+\% years(1)
# "2013-02-28 UTC"
leap \%m+\% years(-1)
leap \%m-\% years(1)
# "2011-02-28 UTC"
}

