% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{survivalG}
\alias{survivalG}
\title{G-estimator for Cox and Fine-Gray model}
\usage{
survivalG(x, data, time = NULL)
}
\arguments{
\item{x}{phreg or cifreg object}

\item{data}{data frame for risk averaging}

\item{time}{for estimate}
}
\description{
Computes G-estimator \deqn{ \hat S(t,A=a) = n^{-1} \sum_i \hat S(t,A=a,Z_i) }
for the Cox model based on phreg og the Fine-Gray model based on the
cifreg function. Assumes that the first covariate is $A$ and this is a factor. 
Gives influence functions of these risk estimates and SE's are based on
these.
}
\examples{

data(bmt); bmt$time <- bmt$time+runif(408)*0.001
bmt$event <- (bmt$cause!=0)*1
dfactor(bmt) <- tcell~tcell

fg1 <- cifreg(Event(time,cause)~tcell+platelet+age,bmt,cause=1,
              cox.prep=TRUE,propodds=NULL)
summary(survivalG(fg1,bmt,50))

ss <- phreg(Surv(time,event)~tcell+platelet+age,bmt) 
summary(survivalG(ss,bmt,50))
}
\author{
Thomas Scheike
}
