% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_all}
\alias{load_all}
\alias{is_loading}
\title{Load complete package}
\usage{
load_all(
  path = ".",
  reset = TRUE,
  compile = NA,
  attach = TRUE,
  export_all = TRUE,
  export_imports = export_all,
  helpers = TRUE,
  attach_testthat = uses_testthat(path),
  quiet = NULL,
  recompile = FALSE,
  warn_conflicts = TRUE
)

is_loading(pkg = NULL)
}
\arguments{
\item{path}{Path to a package, or within a package.}

\item{reset}{clear package environment and reset file cache before loading
any pieces of the package. This largely equivalent to running
\code{\link[=unload]{unload()}}, however the old namespaces are not completely removed and no
\code{.onUnload()} hooks are called. Use \code{reset = FALSE} may be faster for
large code bases, but is a significantly less accurate approximation.}

\item{compile}{If \code{TRUE} always recompiles the package; if \code{NA}
recompiles if needed (as determined by \code{\link[pkgbuild:needs_compile]{pkgbuild::needs_compile()}});
if \code{FALSE}, never recompiles.}

\item{attach}{Whether to attach a package environment to the search
path. If \code{FALSE} \code{load_all()} behaves like \code{loadNamespace()}. If
\code{TRUE} (the default), it behaves like \code{library()}. If \code{FALSE},
the \code{export_all}, \code{export_imports}, and \code{helpers} arguments have
no effect.}

\item{export_all}{If \code{TRUE} (the default), export all objects.
If \code{FALSE}, export only the objects that are listed as exports
in the NAMESPACE file.}

\item{export_imports}{If \code{TRUE} (the default), export all objects that are
imported by the package. If \code{FALSE} export only objects defined in the
package.}

\item{helpers}{if \code{TRUE} loads \pkg{testthat} test helpers.}

\item{attach_testthat}{If \code{TRUE}, attach \pkg{testthat} to the search path,
which more closely mimics the environment within test files.}

\item{quiet}{if \code{TRUE} suppresses output from this function.}

\item{recompile}{DEPRECATED. force a recompile of DLL from source code, if
present. This is equivalent to running \code{\link[pkgbuild:clean_dll]{pkgbuild::clean_dll()}} before
\code{load_all}}

\item{warn_conflicts}{If \code{TRUE}, issues a warning if a function in the global
environment masks a function in the package. This can happen when you
accidentally source a \code{.R} file, rather than using \code{load_all()}, or if you
define a function directly in the R console. This is frustrating to debug,
as it feels like the changes you make to the package source aren't having
the expected effect.}

\item{pkg}{If supplied, \code{is_loading()} only returns \code{TRUE} if the
package being loaded is \code{pkg}.}
}
\description{
\code{load_all} loads a package. It roughly simulates what happens
when a package is installed and loaded with \code{\link[=library]{library()}}.
}
\details{
Currently \code{load_all}:
\itemize{
\item Loads all data files in \verb{data/}.  See \code{\link[=load_data]{load_data()}} for more
details.
\item Sources all R files in the R directory, storing results in
environment that behaves like a regular package namespace. See
below and \code{\link[=load_code]{load_code()}} for more details.
\item Compiles any C, C++, or Fortran code in the \verb{src/} directory and
connects the generated DLL into R. See \code{\link[pkgbuild:compile_dll]{pkgbuild::compile_dll()}}
for more details.
\item Loads any compiled translations in \code{inst/po}.
\item Runs \code{.onAttach()}, \code{.onLoad()} and \code{.onUnload()} functions at
the correct times.
\item If you use \pkg{testthat}, will load all test helpers so you can
access them interactively. devtools sets the \code{DEVTOOLS_LOAD}
environment variable to \code{"true"} to let you check whether the
helpers are run during package loading.
}

\code{is_loading()} returns \code{TRUE} when it is called while \code{load_all()}
is running. This may be useful e.g. in onLoad hooks.
}
\section{Differences with \code{loadNamespace()} and \code{library()}}{

\code{load_all()} tries its best to reproduce the behaviour of
\code{\link[=loadNamespace]{loadNamespace()}} and \code{\link[=library]{library()}}. However it deviates from normal
package loading in several ways.
\itemize{
\item It doesn't install the package on disk, so \code{\link[=system.file]{system.file()}} has no
way of determining the location of the development files. To work
around this, pkgload installs its own version of \code{\link[=system.file]{system.file()}}
on the search path to make it easier to use interactively while
developing. However this definition is only visible to the global
environment, not to the namespaces of third party packages.

One workaround for other packages to see the development files of
your package while you're developing with devtools is for them to
use \code{fs::path_package()} instead of \code{system.file()}.
\item Whereas \code{loadNamespace()} and \code{library()} only load package
dependencies when they are needed, \code{load_all()} loads all packages
referenced in \code{Imports} at load time.
}
}

\section{Namespaces}{

The namespace environment \verb{<namespace:pkgname>}, is a child of
the imports environment, which has the name attribute
\code{imports:pkgname}. It is in turn is a child of
\verb{<namespace:base>}, which is a child of the global environment.
(There is also a copy of the base namespace that is a child of the empty
environment.)

The package environment \verb{<package:pkgname>} is an ancestor of the
global environment. Normally when loading a package, the objects
listed as exports in the NAMESPACE file are copied from the namespace
to the package environment. However, \code{load_all} by default will
copy all objects (not just the ones listed as exports) to the package
environment. This is useful during development because it makes all
objects easy to access.

To export only the objects listed as exports, use
\code{export_all=FALSE}. This more closely simulates behavior when
loading an installed package with \code{\link[=library]{library()}}, and can be
useful for checking for missing exports.
}

\section{Shim files}{

\code{load_all} also inserts shim functions into the imports environment
of the loaded package. It presently adds a replacement version of
\code{system.file} which returns different paths from
\code{base::system.file}. This is needed because installed and uninstalled
package sources have different directory structures. Note that this is not
a perfect replacement for \code{base::system.file}.
}

\examples{
\dontrun{
# Load the package in the current directory
load_all("./")

# Running again loads changed files
load_all("./")

# With reset=TRUE, unload and reload the package for a clean start
load_all("./", TRUE)

# With export_all=FALSE, only objects listed as exports in NAMESPACE
# are exported
load_all("./", export_all = FALSE)
}
}
\keyword{programming}
