% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entrez_search.r
\name{entrez_search}
\alias{entrez_search}
\title{Search the NCBI databases using EUtils}
\usage{
entrez_search(db, term, config = NULL, retmode = "xml",
  use_history = FALSE, ...)
}
\arguments{
\item{db}{character, name of the database to search for.}

\item{term}{character, the search term.}

\item{config}{vector configuration options passed to httr::GET}

\item{retmode}{character, one of json (default) or xml. This will make no
difference in most cases.}

\item{use_history}{logical. If TRUE return a web_history object for use in 
later calls to the NCBI}

\item{\dots}{characte, additional terms to add to the request, see NCBI
documentation linked to in references for a complete list}
}
\value{
ids integer Unique IDS returned by the search

count integer Total number of hits for the search

retmax integer Maximum number of hits returned by the search

web_history A web_history object for use in subsequent calls to NCBI

QueryTranslation character, search term as the NCBI interpreted it

file either and XMLInternalDocument xml file resulting from search, parsed with
\code{\link[XML]{xmlTreeParse}} or, if \code{retmode} was set to json a list
resulting from the returned JSON file being parsed with
\code{\link[jsonlite]{fromJSON}}.
}
\description{
The NCBI uses a search term syntax where search terms can be associated with 
a specific search field with square brackets. So, for instance ``Homo[ORGN]''
denotes a search for Homo in the ``Organism'' field. The names and
definitions of these fields can be identified using
\code{\link{entrez_db_searchable}}.
}
\details{
Searches can make use of several fields by combining them via the boolean
operators AND, OR and NOT. So, using the search term``((Homo[ORGN] AND APP[GENE]) NOT
Review[PTYP])'' in PubMed would identify articles matching the gene APP in
humans, and exclude review articles. More examples of the use of these search
terms, and the more specific MeSH terms for precise searching, 
is given in the package vignette.
}
\examples{
\dontrun{
   query <- "Gastropoda[Organism] AND COI[Gene]"
   web_env_search <- entrez_search(db="nuccore", query, use_history=TRUE)
   cookie <- web_env_search$WebEnv
   qk <- web_env_search$QueryKey 
   snail_coi <- entrez_fetch(db = "nuccore", WebEnv = cookie, query_key = qk,
                             file_format = "fasta", retmax = 10)
}
\donttest{

fly_id <- entrez_search(db="taxonomy", term="Drosophila")
#Oh, right. There is a genus and a subgenus name Drosophila...
#how can we limit this search
(tax_fields <- entrez_db_searchable("taxonomy"))
#"RANK" loots promising
tax_fields$RANK
entrez_search(db="taxonomy", term="Drosophila & Genus[RANK]")
}
}
\references{
\url{http://www.ncbi.nlm.nih.gov/books/NBK25499/#_chapter4_ESearch_}
}
\seealso{
\code{\link[httr]{config}} for available httr configurations

\code{\link{entrez_db_searchable}} to get a set of search fields that
can be used in \code{term} for any database
}

