% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publications.R
\name{publications}
\alias{publications}
\title{Returns a list of the pulications used for the TSN.}
\usage{
publications(tsn, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{tsn}{TSN for a taxonomic group (numeric). Required.}

\item{wt}{(character) One of "json" or "xml". Required.}

\item{raw}{(logical) Return raw JSON or XML as character string. Required.
Default: \code{FALSE}}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\value{
a data.frame
}
\description{
Returns a list of the pulications used for the TSN.
}
\examples{
\dontrun{
publications(tsn = 70340)
publications(tsn = 70340, wt = "xml")

library(httr)
publications(tsn = 70340, config = verbose())
}
}

