% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_design.R
\docType{class}
\name{TrialDesignGroupSequential}
\alias{TrialDesignGroupSequential}
\title{Group Sequential Design}
\description{
Trial design for group sequential design.
}
\details{
This object should not be created directly; use \code{\link[=getDesignGroupSequential]{getDesignGroupSequential()}}
with suitable arguments to create a group sequential design.
}
\section{Fields}{

\describe{
\item{\code{kMax}}{The maximum number of stages \code{K}.
Is a positive integer of length 1 (default value is \code{3}).
The maximum selectable \code{kMax} is \code{20} for group sequential or inverse normal and
\code{6} for Fisher combination test designs.}

\item{\code{alpha}}{The significance level alpha, default is `0.025`.
Is a positive numeric of length 1.}

\item{\code{stages}}{The stage numbers of the trial. Is an integer vector of length \code{kMax}.}

\item{\code{informationRates}}{The information rates (that must be fixed prior to the trial), 
default is \code{(1:kMax) / kMax}. Is a numeric vector of length \code{kMax} (the maximum number of stages).}

\item{\code{userAlphaSpending}}{The user defined alpha spending. 
Numeric vector of length \code{kMax} containing the cumulative 
alpha-spending (Type I error rate) up to each interim stage: \code{0 <= alpha_1 <= ... <= alpha_K <= alpha}.}

\item{\code{criticalValues}}{The critical values for each stage of the trial. 
Is a numeric vector of length \code{kMax} (the maximum number of stages).}

\item{\code{stageLevels}}{The levels for each stage.}

\item{\code{alphaSpent}}{The cumulative alpha spent at each stage.
Is a numeric vector with length \code{kMax} (the maximum number of stages).}

\item{\code{bindingFutility}}{Logical. If \code{bindingFutility = TRUE} is specified the calculation of 
the critical values is affected by the futility bounds and the futility threshold is binding in the 
sense that the study must be stopped if the futility condition was reached (default is \code{FALSE}).}

\item{\code{tolerance}}{The numerical tolerance, default is \code{1e-06}. Is a positive numeric of length 1.}

\item{\code{typeOfDesign}}{The type of design. Type of design is one of the following: 
O'Brien & Fleming (\code{"OF"}), Pocock (\code{"P"}), Wang & Tsiatis Delta class (\code{"WT"}), 
Pampallona & Tsiatis (\code{"PT"}), Haybittle & Peto ("HP"), 
Optimum design within Wang & Tsiatis class (\code{"WToptimum"}), 
O'Brien & Fleming type alpha spending (\code{"asOF"}), Pocock type alpha spending (\code{"asP"}), 
Kim & DeMets alpha spending (\code{"asKD"}), Hwang, Shi & DeCani alpha spending (\code{"asHSD"}), 
user defined alpha spending (\code{"asUser"}), no early efficacy stop (\code{"noEarlyEfficacy"}), 
default is \code{"OF"}.}

\item{\code{beta}}{Type II error rate, necessary for providing sample size calculations \cr
(e.g., \code{\link[=getSampleSizeMeans]{getSampleSizeMeans()}}), beta spending function designs, 
or optimum designs, default is \code{0.20}. Is a positive numeric of length 1.}

\item{\code{deltaWT}}{Delta for Wang & Tsiatis Delta class.
Is a numeric vector of length 1.}

\item{\code{deltaPT1}}{Delta1 for Pampallona & Tsiatis class rejecting H0 boundaries.
Is a numeric vector of length 1.}

\item{\code{deltaPT0}}{Delta0 for Pampallona & Tsiatis class rejecting H1 boundaries.
Is a numeric vector of length 1.}

\item{\code{futilityBounds}}{The futility bounds for each stage of the trial.
Is a numeric vector of length \code{kMax} - 1, where \code{kMax} is the maximum number of stages.}

\item{\code{gammaA}}{Parameter for alpha spending function.
Is a numeric vector of length 1.}

\item{\code{gammaB}}{Parameter for beta spending function.
Is a numeric vector of length 1.}

\item{\code{optimizationCriterion}}{Optimization criterion for optimum design within Wang & Tsiatis class ("ASNH1", "ASNIFH1", "ASNsum"), default is "ASNH1".}

\item{\code{sided}}{Is the alternative one-sided (\code{1}) or two-sided (\code{2}), default is \code{1}. 
Is a positive integer of length 1.}

\item{\code{betaSpent}}{The cumulative beta level spent at each stage of the trial.
For beta-spending designs, is a numeric vector of length \code{kMax} (the maximum number of stages).}

\item{\code{typeBetaSpending}}{Type of beta spending. Type of of beta spending is one of the following: O'Brien & Fleming type beta spending, 
Pocock type beta spending, Kim & DeMets beta spending, Hwang, Shi & DeCani beta spending, 
user defined beta spending ("bsOF", "bsP", "bsKD", "bsHSD", "bsUser", default is "none").}

\item{\code{userBetaSpending}}{The user defined beta spending. Vector of length \code{kMax} containing the cumulative beta-spending up to each interim stage.}

\item{\code{power}}{The one-sided power at each stage of the trial.
Is a numeric vector of length \code{kMax} (the maximum number of stages).}

\item{\code{twoSidedPower}}{Two-sided power at each stage of the trial.
Is a numeric vector of length \code{kMax} (the maximum number of stages).}

\item{\code{constantBoundsHP}}{The constant bounds up to stage kMax - 1 for the Haybittle & Peto design (default is 3).}

\item{\code{betaAdjustment}}{Logical. If \code{TRUE}, beta spending values are 
linearly adjusted if an overlapping of decision regions for futility 
stopping at earlier stages occurs.
Only applicable for two-sided beta-spending designs.}

\item{\code{delayedInformation}}{Delay of information for delayed response designs.
Is a numeric value or a numeric vector of length \code{kMax} - 1.}

\item{\code{decisionCriticalValues}}{TODO}

\item{\code{reversalProbabilities}}{TODO}
}}


\seealso{
\code{\link[=getDesignGroupSequential]{getDesignGroupSequential()}} for creating a group sequential design.
}
\keyword{internal}
