% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_users.R
\name{search_users}
\alias{search_users}
\title{Search for users}
\usage{
search_users(q, n = 100, parse = TRUE, token = NULL, verbose = TRUE)
}
\arguments{
\item{q}{As string providing the search query. Try searching by interest,
full name, company name, or location. Exact match searches are not
supported.}

\item{n}{Desired number of results to return. Results are downloaded
in pages when \code{n} is large; the default value will download a single
page. Set \code{n = Inf} to download as many results as possible.

The Twitter API rate limits the number of requests you can perform
in each 15 minute period. The easiest way to download more than that is
to use \code{retryonratelimit = TRUE}.

You are not guaranteed to get exactly \code{n} results back. You will get
fewer results when tweets have been deleted or if you hit a rate limit.
You will get more results if you ask for a number of tweets that's not
a multiple of page size, e.g. if you request \code{n = 150} and the page
size is 200, you'll get 200 results back.}

\item{parse}{If \code{TRUE}, the default, returns a tidy data frame. Use \code{FALSE}
to return the "raw" list corresponding to the JSON returned from the
Twitter API.}

\item{token}{Expert use only. Use this to override authentication for
a single API call. In most cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}

\item{verbose}{Show progress bars and other messages indicating current
progress?}
}
\value{
Data frame with one row for each matching user.
}
\description{
Search for Twitter users. The Twitter API limits the results to at most
1,000 users.
}
\examples{
if (auth_has_default()) {
users <- search_users("#rstats", n = 300)
users

# latest tweet from each user
tweets_data(users)
}

}
\references{
\url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/follow-search-get-users/api-reference/get-users-search}
}
\seealso{
Other users: 
\code{\link{as_screenname}()},
\code{\link{lists_subscribers}()},
\code{\link{lookup_users}()}
}
\concept{users}
