% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/dimensional_reduction.R
\name{ProjectUMAP}
\alias{ProjectUMAP}
\alias{ProjectUMAP.default}
\alias{ProjectUMAP.DimReduc}
\alias{ProjectUMAP.Seurat}
\title{Project query into UMAP coordinates of a reference}
\usage{
ProjectUMAP(query, ...)

\method{ProjectUMAP}{default}(
  query,
  query.dims = NULL,
  reference,
  reference.dims = NULL,
  k.param = 20,
  nn.method = "annoy",
  n.trees = 50,
  annoy.metric = "cosine",
  l2.norm = FALSE,
  cache.index = TRUE,
  index = NULL,
  neighbor.name = "query_ref.nn",
  reduction.model,
  ...
)

\method{ProjectUMAP}{DimReduc}(
  query,
  query.dims = NULL,
  reference,
  reference.dims = NULL,
  k.param = 20,
  nn.method = "annoy",
  n.trees = 50,
  annoy.metric = "cosine",
  l2.norm = FALSE,
  cache.index = TRUE,
  index = NULL,
  neighbor.name = "query_ref.nn",
  reduction.model,
  ...
)

\method{ProjectUMAP}{Seurat}(
  query,
  query.reduction,
  query.dims = NULL,
  reference,
  reference.reduction,
  reference.dims = NULL,
  k.param = 20,
  nn.method = "annoy",
  n.trees = 50,
  annoy.metric = "cosine",
  l2.norm = FALSE,
  cache.index = TRUE,
  index = NULL,
  neighbor.name = "query_ref.nn",
  reduction.model,
  reduction.name = "ref.umap",
  reduction.key = "refUMAP_",
  ...
)
}
\arguments{
\item{query}{Query dataset}

\item{...}{Additional parameters to \code{\link{RunUMAP}}}

\item{query.dims}{Dimensions (columns) to use from query}

\item{reference}{Reference dataset}

\item{reference.dims}{Dimensions (columns) to use from reference}

\item{k.param}{Defines k for the k-nearest neighbor algorithm}

\item{nn.method}{Method for nearest neighbor finding. Options include: rann,
annoy}

\item{n.trees}{More trees gives higher precision when using annoy approximate
nearest neighbor search}

\item{annoy.metric}{Distance metric for annoy. Options include: euclidean,
cosine, manhattan, and hamming}

\item{l2.norm}{Take L2Norm of the data}

\item{cache.index}{Include cached index in returned Neighbor object
(only relevant if return.neighbor = TRUE)}

\item{index}{Precomputed index. Useful if querying new data against existing
index to avoid recomputing.}

\item{neighbor.name}{Name to store neighbor information in the query}

\item{reduction.model}{\code{DimReduc} object that contains the umap model}

\item{query.reduction}{Name of reduction to use from the query for neighbor
finding}

\item{reference.reduction}{Name of reduction to use from the reference for
neighbor finding}

\item{reduction.name}{Name of projected UMAP to store in the query}

\item{reduction.key}{Value for the projected UMAP key}
}
\description{
This function will take a query dataset and project it into the coordinates
of a provided reference UMAP. This is essentially a wrapper around two steps:
\itemize{
  \item{FindNeighbors - Find the nearest reference cell neighbors and their
  distances for each query cell.}
  \item{RunUMAP - Perform umap projection by providing the neighbor set
  calculated above and the umap model previously computed in the reference.}
}
}
\concept{dimensional_reduction}
