% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete.R
\name{delete}
\alias{delete}
\alias{delete_by_id}
\alias{delete_by_query}
\title{Delete documents by ID or query}
\usage{
delete_by_id(conn, ids, name, commit = TRUE, commit_within = NULL,
  overwrite = TRUE, boost = NULL, wt = "json", raw = FALSE, ...)

delete_by_query(conn, query, name, commit = TRUE, commit_within = NULL,
  overwrite = TRUE, boost = NULL, wt = "json", raw = FALSE, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{ids}{Document IDs, one or more in a vector or list}

\item{name}{(character) A collection or core name. Required.}

\item{commit}{(logical) If \code{TRUE}, documents immediately searchable.
Deafult: \code{TRUE}}

\item{commit_within}{(numeric) Milliseconds to commit the change, the
document will be added within that time. Default: \code{NULL}}

\item{overwrite}{(logical) Overwrite documents with matching keys.
Default: \code{TRUE}}

\item{boost}{(numeric) Boost factor. Default: \code{NULL}}

\item{wt}{(character) One of json (default) or xml. If json, uses
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} to parse. If xml, uses \code{\link[xml2:read_xml]{xml2::read_xml()}} to
parse}

\item{raw}{(logical) If \code{TRUE}, returns raw data in format specified by
\code{wt} param}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}

\item{query}{Query to use to delete documents}
}
\description{
Delete documents by ID or query
}
\details{
We use json internally as data interchange format for this function.
}
\examples{
\dontrun{
(cli <- SolrClient$new())

# add some documents first
ss <- list(list(id = 1, price = 100), list(id = 2, price = 500))
cli$add(ss, name = "gettingstarted")

# Now, delete them
# Delete by ID
cli$delete_by_id(ids = 1, "gettingstarted")
## Many IDs
cli$delete_by_id(ids = c(3, 4), "gettingstarted")

# Delete by query 
cli$search("gettingstarted", params=list(q="*:*")) # apple is there
cli$delete_by_query(query = 'id:apple', "gettingstarted") # delete it
cli$search("gettingstarted", params=list(q='id:apple')) # apple is now gone
}
}
