% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shape_text.R
\name{shape_text}
\alias{shape_text}
\title{Calculate glyph positions for strings}
\usage{
shape_text(
  strings,
  id = NULL,
  family = "",
  italic = FALSE,
  bold = FALSE,
  size = 12,
  res = 72,
  lineheight = 1,
  align = "left",
  hjust = 0,
  vjust = 0,
  width = NA,
  tracking = 0,
  indent = 0,
  hanging = 0,
  space_before = 0,
  space_after = 0,
  path = NULL,
  index = 0
)
}
\arguments{
\item{strings}{A character vector of strings to shape}

\item{id}{A vector grouping the strings together. If strings share an id the
shaping will continue between strings}

\item{family}{The name of the font family}

\item{italic}{logicals indicating the font style}

\item{bold}{logicals indicating the font style}

\item{size}{The pointsize of the font to use for size related measures}

\item{res}{The ppi of the size related mesures}

\item{lineheight}{A multiplier for the lineheight}

\item{align}{Within text box alignment, either \code{'left'}, \code{'center'}, or
\code{'right'}}

\item{hjust, vjust}{The justification of the textbox surrounding the text}

\item{width}{The requested with of the string in inches. Setting this to
something other than \code{NA} will turn on word wrapping.}

\item{tracking}{Tracking of the glyphs (space adjustment) measured in 1/1000
em.}

\item{indent}{The indent of the first line in a paragraph measured in inches.}

\item{hanging}{The indent of the remaining lines in a paragraph measured in
inches.}

\item{space_before, space_after}{The spacing above and below a paragraph,
measured in points}

\item{path, index}{path an index of a font file to circumvent lookup based on
family and style}
}
\value{
A list with two element: \code{shape} contains the position of each glyph,
relative to the origin in the enclosing textbox. \code{metrics} contain metrics
about the full strings.

\code{shape} is a data.frame with the following columns:
\describe{
\item{glyph}{The glyph as a character}
\item{index}{The index of the glyph in the font file}
\item{metric_id}{The index of the string the glyph is part of (referencing a row in the \code{metrics} data.frame)}
\item{string_id}{The index of the string the glyph came from (referencing an element in the \code{strings} input)}
\item{x_offset}{The x offset in pixels from the origin of the textbox}
\item{y_offset}{The y offset in pixels from the origin of the textbox}
\item{x_mid}{The x offset in pixels to the middle of the glyph, measured from the origin of the glyph}
}

\code{metrics} is a data.frame with the following columns:
\describe{
\item{string}{The text the string consist of}
\item{width}{The width of the string}
\item{height}{The height of the string}
\item{left_bearing}{The distance from the left edge of the textbox and the leftmost glyph}
\item{right_bearing}{The distance from the right edge of the textbox and the rightmost glyph}
\item{top_bearing}{The distance from the top edge of the textbox and the topmost glyph}
\item{bottom_bearing}{The distance from the bottom edge of the textbox and the bottommost glyph}
\item{left_border}{The position of the leftmost edge of the textbox related to the origin}
\item{top_border}{The position of the topmost edge of the textbox related to the origin}
\item{pen_x}{The horizontal position of the next glyph after the string}
\item{pen_y}{The vertical position of the next glyph after the string}
}
}
\description{
Do basic text shaping of strings. This function will use freetype to
calculate advances, doing kerning if possible. It will not perform any font
substitution or ligature resolving and will thus be much in line with how
the standard graphic devices does text shaping. Inputs are recycled to the
length of \code{strings}.
}
\examples{
string <- "This is a long string\nLook; It spans multiple lines\nand all"

# Shape with default settings
shape_text(string)

# Mix styles within the same string
string <- c(
  "This string will have\na ",
  "very large",
  " text style\nin the middle"
)

shape_text(string, id = c(1, 1, 1), size = c(12, 24, 12))

}
