% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slice.R
\name{vec_as_index}
\alias{vec_as_index}
\title{Create an index}
\usage{
vec_as_index(i, n, names = NULL)
}
\arguments{
\item{i}{An integer, character or logical vector specifying the positions or
names of the observations to get/set.
Specify \code{TRUE} to index all elements (as in \code{x[]}), or \code{NULL}, \code{FALSE} or
\code{integer()} to index none (as in \code{x[NULL]}).}

\item{n}{A single integer representing the total size of the
object that \code{i} is meant to index into.}

\item{names}{If \code{i} is a character vector, \code{names} should be a character
vector that \code{i} will be matched against to construct the index. Otherwise,
not used. The default value of \code{NULL} will result in an error
if \code{i} is a character vector.}
}
\value{
An integer vector that can be used as an index in a subsetting operation.
}
\description{
This provides a means of standardizing common indexing methods such as
integer, character or logical indexing. The input is a vector of one
of these three types, and the output is always an integer vector that can
be used for subsetting.
}
\examples{
x <- array(1:6, c(2, 3))
dimnames(x) <- list(c("r1", "r2"), c("c1", "c2", "c3"))

# The most common use case validates row indices
vec_as_index(1, vec_size(x))

# Negative indices can be used to index from the back
vec_as_index(-1, vec_size(x))

# Character vectors can be used if `names` are provided
vec_as_index("r2", vec_size(x), rownames(x))

# You can also construct an index for dimensions other than the first
vec_as_index(c("c2", "c1"), ncol(x), colnames(x))

}
\keyword{internal}
