"identity" <-
function( alignment ) {

  if(is.list(alignment)) alignment <- alignment$ali
    is.gap <- function(x, gap.char=c("-",".")) {
      return( as.logical( is.na(x) + (x %in% gap.char) ) )
    }
    ide <- function(x, y) {
        tmp <- rbind(x, y)
        gaps <- unique( c(which(is.gap(x)), which(is.gap(y))))
        if(length(gaps) > 0) {
          return(round(sum(x[-gaps] == y[-gaps])/length(x[-gaps]), 
                       3))
        } else {
          return(round(sum(x == y)/length(x), 3))
        }
        
    }

  nseq <- nrow(alignment)
  inds <- pairwise( nseq )
  ni <- nrow(inds)
  s <- rep(NA, ni)
  
  for(i in 1:ni) {
    s[i]<-ide(alignment[inds[i,1],], alignment[inds[i,2],])
  }
      # make 's' into matrix 'sm'
  sm <- matrix(1, ncol=nseq,nrow=nseq)
  sm[inds]<-s
  if(nseq==2) {
    sm[inds[,2], inds[,1]]<-s
  } else {
    sm[inds[,c(2,1)]]<-s 
  }
  return(sm) # ide matrix
}

