"mktrj.pca" <-
function(pca=NULL,   # pca data structure
                      pc=1,       # which pc to move along
                      mag=1,      # magnification factor
                      step=0.125, # step size
                      file=NULL,
                      resno=NULL,
                      resid=NULL, ... ) {
                      
  # make a trjactory of atomic displacments along a given pc

  
  if(class(pca)!="pca") {
    stop("input should be a list object of class 'pca' (from 'pca.xyz')")
  }

  store.plus<- NULL   # move from mean
  i<-step             # in + direction
  while(i<=mag){
    scale<-sqrt(pca$L[pc])*i
    x<-scale*pca$U[,pc]+pca$mean
    store.plus<-rbind(store.plus,x)
    i<-i+step
  }
  # and back
  store.plus <- rbind(store.plus,
                      store.plus[ rev(1:nrow(store.plus)), ])

  store.minus <- NULL  # move from mean
  i<-step              # in - direction
  while(i<=mag){
    scale<--sqrt(pca$L[pc])*i
    x<-scale*pca$U[,pc]+pca$mean
    store.minus<-rbind(store.minus,x)
    i<-i+step
  }
  # and back
  store.minus <- rbind(store.minus,
                       store.minus[ rev(1:nrow(store.minus)), ])

  store.all <- rbind(store.plus,store.minus)

  if (!is.null(file)) {
    unlink(file) # remove existing file
    if(is.null(resid)) resid <- rep("ALA", (length(store.all[i,])/3))
    if(is.null(resno)) resno <- c(1:(length(store.all[i,])/3))
    
    for(i in 1:nrow(store.all)) {
      write.pdb(xyz   = store.all[i,],
                resid = resid,
                resno = resno,
                append=TRUE,
                file=file, ... )

    }
  }  
  return(store.all)  # class xyz?
}

