\name{plot.blast}
\alias{plot.blast}
\title{ Plot BLAST Hit Statistics. }
\description{
  Produces a number of basic plots that should facilitate hit selection
  from the match statistics of a BLAST result.
}
\usage{
plot.blast(b, cutoff = 110)
}
\arguments{
  \item{b}{ BLAST results as obtained from the function
    \code{\link{blast.pdb}}. }
  \item{cutoff}{ A cutoff value, in terms of minus the log of the evalue,
    for returned hits (see below). }
}
\details{
  Examining plots of BLAST alignment lengths, scores, E-values and normalized
  scores (-log(E-Value)) can aid in the identification sensible hits.
}
\value{
  Produces a plot on the active graphics device and returns a matrix
  with the PDB and GI identifiers of the subset of hits with a normalized
  score above the chosen cutoff.
}
\references{
  Grant, B.J. et al. (2006) \emph{Bioinformatics} \bold{22}, 2695--2696.
}
\author{ Barry Grant }
\note{ TO BE IMPROVED. 
}
\seealso{ ~~objects to See Also as \code{\link{help}}, ~~~ }
\examples{
##pdb <- read.pdb( get.pdb("5p21", URLonly=TRUE) )
##blast <- blast.pdb( seq.pdb(pdb), database = "swiss" )
##ids <- plot.blast( blast )
##get.seq(ids)
}
\keyword{ hplot }
