#ifndef race_tile_map
#define race_tile_map

#include "attractor.h"
#include "start_pos.h"

class tileMap
{
 public:
	tileMap();
	void load_map( CL_String );
	int get_tmp_map(int x, int y) { return tmp_map[y][x]; } // TODO: txt_map would be a better name
	int get_tile_id(int x, int y) { return map[y][x]; }

	int get_data( int x, int y ) { return data_map[y][x]; }
	int get_tmp_data( int x, int y ) { return tmp_data_map[y][x]; }

	int get_attractor_x(char num);
	int get_attractor_y(char num);
	int get_num_attractors();

	CL_String get_filename() { return filename; }
	CL_String set_filename(CL_String str) { filename = str; }

	CL_String filename;

	// set  

	void set_map(int x, int y, int val) { map[y][x]=val; }
	void set_tmp_map(int x, int y, int val) { tmp_map[y][x]=val; }

	void set_data(int x, int y, int val) { data_map[y][x]=val; }


	// smooth 

	void smooth_no_borders();

	// load 

	void load_track( CL_String filename );

	void load_drive( CL_String filename );
	void load_drive_new( CL_String filename );

	void load_data( CL_String filename );
	void load_start( CL_String filename );

	void load_numbers( CL_String filename );
  	void save_numbers( CL_String filename );

	// misc 

	std::vector<Attractor> attractors;
	std::vector<StartPosition> start_positions;

	bool has_pit() { return pit; }

	float track_record;
	CL_String track_record_holder;

 private:
	
	int tmp_map[40+1][40+1];   // map loaded from file 
	int map[40+1][40+1];       // final "rounded" map 
	
	int tmp_data_map[40+1][40+1]; 
	int data_map[40+1][40+1];  // trees, walls, buildings 

	bool pit;	
};

#endif // header_map
