/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
*/

#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include "../tile_enums.h"
#include "../graphics.h"
#include "../height_map.h"
#include "../object_3d.h"

#include "fence.h"

Texture Fence::fence_tex;
Object3D *Fence::h3d_fence = NULL;

void Fence::draw(int x, int y, float z, int item)
{
	if( HeightMap::under_water(x,y,z) )
		return;	

	glPushMatrix();
	
	glTranslatef(x,y,z);
	
	fence_tex.bind();
	
	if( item == Items(FENCE_H))
	{
		glPushMatrix();
		glRotatef( 90.0f, 0.0f,0.0f, 1.0f);
		h3d_fence->draw();
		glPopMatrix();
	}
	if( item == Items(FENCE_V))
	{
		h3d_fence->draw();
	}

	glPopMatrix();
}


void Fence::load( CL_ResourceManager &res )
{
	if( h3d_fence != NULL )
		delete h3d_fence;

	fence_tex = Texture(CL_Surface::load( "fence_tex", &res ));
	h3d_fence = Object3D::load( "fence", &res );
}

