#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "../menu_gfx.h"
#include "../../game_config.h"
#include "../../theme_loader.h"
#include "../../debug.h"
#include "options_themes.h"


OptionsThemes::OptionsThemes(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(145, 150, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		lbox_themes( CL_Rect(10, 10, 150 + 10, 200), this, style ),
		check_random( CL_Point(210,40),"random theme", this, style )
{
	RaceDebug::print( "OptionsThemes: constructor", 9 );

	slots.connect( sig_paint(), this, &OptionsThemes::on_paint );
	slots.connect( lbox_themes.sig_selection_changed(), this, &OptionsThemes::on_theme_selected);

	load_theme_list();
}

void OptionsThemes::on_paint()
{
	MenuGfx::submenu_frame_bg->put_screen(0,0);
}

void OptionsThemes::on_theme_selected()
{
	cout << "selected: " << lbox_themes.get_current_text().c_str() << endl;
	
	Config::selected_theme = lbox_themes.get_current_item();
	
	ThemeLoader::load_theme(Config::selected_theme);
}

//----------------------------------------------------------------
// not purely gui stuff

void OptionsThemes::load_theme_list()
{
	std::vector<std::string> theme_list = ThemeLoader::get_theme_list();
	std::vector<std::string>::iterator it;
	
	for( it = theme_list.begin(); it != theme_list.end(); it++ )
		lbox_themes.insert_item((*it));
}










