#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#include <algorithm>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "GUI/stylemanager_opengl.h"

#include "../music.h"
#include "../game_config.h"
#include "../fonts.h"
#include "../config.h"
#include "../game_data.h"
#include "../race_opengl.h"
#include "../car.h"
#include "../game_data.h"
#include "menu_gfx.h"
#include "result_menu.h"

void ResultMenu::show(bool final)
{
	Race_OpenGL::begin_2d(); 
	Race_OpenGL::begin_2d(); // dunno why, but it doesn't work without it.

	Music::fade_out();

	CL_String path = DATADIR;
	path += "resources/gui.res";

	CL_ResourceManager resources(path, false);
	CL_StyleManager_OpenGL styles(&resources);
	
	ResultMenu result_menu( NULL, &styles, final);
	result_menu.run();

	Race_OpenGL::end_2d();
	Race_OpenGL::end_2d();
}

ResultMenu::ResultMenu(CL_Component *parent, CL_StyleManager *style, bool final)
:
	CL_Component(
			CL_Rect(0, 0, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		btn_continue( CL_Rect( 10, 160, 10 + 120, 160 + 30), "Continue", this, style )
{
	slots.connect( sig_paint(), this, &ResultMenu::on_paint );
	slots.connect( btn_continue.sig_clicked(), this, &ResultMenu::on_continue );
	
	this->final = final;

	make_entries();
	play_music();  // must be after make_entries()
}

ResultMenu::~ResultMenu()
{
}

void ResultMenu::play_music()
{
	int pos=0;

	std::vector<ResultEntry>::iterator it;

	for( it = results.begin(); it != results.end(); it++, pos++ )
		if(Config::names[(*it).id] == Config::names[0])
			break;

	if( pos > 3 ) pos = 3;

	if( Config::music_on )
		if( Music::load_track(10+pos) )
  			Music::play_track();
}


void ResultMenu::on_paint()
{
	MenuGfx::bg->put_screen(0,0);
	
	Fonts::menu_small->print_right( 800-10, 600-25, "Results" );
	
	if( final )
		show_final_results();
	else
		show_results();

	Music::update();
}

void ResultMenu::on_continue()
{
	quit();
}

void ResultMenu::make_entries()
{
	std::vector<Car*>::iterator it;
	for( it = GameData::cars.begin();
	     it != GameData::cars.end();
	     it++ )
	{
		if( final )
			results.push_back( ResultEntry((*it)->points, (*it)->id) );
		else
			results.push_back( ResultEntry((*it)->last_race_points, (*it)->id) );
	}
	
	// sort based on points
	std::sort( results.begin(), results.end() );
}

	
void ResultMenu::show_final_results()
{
	unsigned short ptx = 0, nx=0, y = 0;
	
	ptx=450; nx=200; y=250;
	
	Fonts::menu_small->print_center( 400, 150, "- - Final Results - -" );
	
	std::vector<ResultEntry>::iterator it;
	
	// print names and points
	for( it = results.begin(); it != results.end(); it++ )
	{
		Fonts::menu_small->print_left( nx, y, Config::names[(*it).id].c_str() );
		Fonts::menu_small->print_left( ptx, y, CL_String(GameData::cars[(*it).id]->points) );
		y += Fonts::menu_small->get_height() +2;
	}
}

void ResultMenu::show_results()
{
	unsigned short plx = 0, ptx = 0, nx=0, y = 0;
	
	plx=500; ptx=450; nx=200; y=200;
	
	std::vector<ResultEntry>::iterator it;
	
	Fonts::menu_small->print_center( 400, 150, "- - Results - -" );
	
	// print names and points
	for( it = results.begin(); it != results.end(); it++ )
	{
		Fonts::menu_small->print_left( nx, y, Config::names[(*it).id].c_str() );
		Fonts::menu_small->print_left( plx, y, CL_String(GameData::cars[(*it).id]->points) );
		Fonts::menu_small->print_left( ptx, y, CL_String(GameData::cars[(*it).id]->last_race_points) );
		y += Fonts::menu_small->get_height() +2;
	}
}
