#include "r_syscall.h"

/* syscall-linux */
RSyscallItem syscalls_linux_x86[] = {
	{ "exit", 0x80, 1, 1, "i" },
	{ "fork", 0x80, 2, 0, NULL },
	{ "read", 0x80, 3, 3, "ipi" },
	{ "write", 0x80, 4, 3, "izi" },
	{ "open", 0x80, 5, 3, "zxx" },
	{ "close", 0x80, 6, 1, "i" },
	{ "waitpid", 0x80, 7, 3, "ipx"},
	{ "creat", 0x80, 8, 2, "zx" },
	{ "link", 0x80, 9, 2, "zz" },
	{ "unlink", 0x80, 10, 1, "z" },
	{ "execve", 0x80, 11, 3, "zzz" }, // XXX this is char**
	{ "chdir", 0x80, 12, 1, "z" },
	{ "getpid", 0x80, 20, 0, NULL},
	{ "setuid", 0x80, 23, 1, "i" },
	{ "getuid", 0x80, 24, 0, NULL },
	{ "ptrace", 0x80, 26, 4 },
	{ "utime", 0x80, 30, 2 },
	{ "access", 0x80, 33, 2 },
	{ "kill", 0x80, 37,2 },
	{ "dup", 0x80, 41, 2 },
	{ "brk", 0x80, 45, 1 },
	{ "signal", 0x80, 48, 2 },
	{ "ioctl", 0x80, 54, 3 },
	{ "mmap", 0x80, 90, 6 },
	{ "munmap", 0x80, 91, 1 },
	{ "socketcall", 0x80, 102, 2 },
	{ "sigreturn", 0x80, 119, 1 },
	{ "clone", 0x80, 120, 4 },
	{ "mprotect", 0x80, 125, 3},
	{ "rt_sigaction", 0x80, 174, 3},
	{ "rt_sigprocmask", 0x80, 175, 3},
	{ "sysctl", 0x80, 149, 1 },
	{ "mmap2", 0x80, 192, 6},
	{ "fstat64", 0x80, 197, 2},
	{ "fcntl64", 0x80, 221, 3},
	{ "gettid", 0x80, 224, 0},
	{ "set_thread_area", 0x80, 243, 2},
	{ "get_thread_area", 0x80, 244, 2},
	{ "exit_group", 0x80, 252, 1},
	{ NULL, 0, 0, 0 }
};

RSyscallItem syscalls_linux_sh[] = {{NULL,0,0,0} };
// http://lxr.oss.org.cn/source/include/asm-arm/unistd.h
/* syscall-linux */
// XXX: same as in linux-x86 ?
RSyscallItem syscalls_linux_arm[] = {
	{ "exit", 0x900000, 1, 1, "i" },
	{ "fork", 0x900000, 2, 0, NULL },
	{ "read", 0x900000, 3, 3, "ipi" },
	{ "write", 0x900000, 4, 3, "izi" },
	{ "open", 0x900000, 5, 3, "zxx" },
	{ "close", 0x900000, 6, 1, "i" },
	{ "waitpid", 0x900000, 7, 3, "ipx"},
	{ "creat", 0x900000, 8, 2, "zx" },
	{ "link", 0x900000, 9, 2, "zz" },
	{ "unlink", 0x900000, 10, 1, "z" },
	{ "execve", 0x900000, 11, 3, "zzz" }, // XXX this is char**
	{ "chdir", 0x900000, 12, 1, "z" },
	{ "time", 0x900000, 13, 1, "p" },
	{ "mknod", 0x900000, 14, 1, "zxi" },
	{ "chmod", 0x900000, 15, 1, "zx" },
	{ "lchown", 0x900000, 16, 1, "zii" },
	{ "getpid", 0x900000, 20, 0, NULL},
	{ "setuid", 0x900000, 23, 1, "i" },
	{ "getuid", 0x900000, 24, 0, NULL },
	{ "ptrace", 0x900000, 26, 4 },
	{ "utime", 0x900000, 30, 2 },
	{ "access", 0x900000, 33, 2 },
	{ "kill", 0x900000, 37,2 },
	{ "dup", 0x900000, 41, 2 },
	{ "brk", 0x900000, 45, 1 },
	{ "signal", 0x900000, 48, 2 },
	{ "ioctl", 0x900000, 54, 3 },
	{ "mmap", 0x900000, 90, 6 },
	{ "munmap", 0x900000, 91, 1 },
	{ "socketcall", 0x900000, 102, 2 },
	{ "sigreturn", 0x900000, 119, 1 },
	{ "clone", 0x900000, 120, 4 },
	{ "mprotect", 0x900000, 125, 3},
	{ "rt_sigaction", 0x900000, 174, 3},
	{ "rt_sigprocmask", 0x900000, 175, 3},
	{ "sysctl", 0x900000, 149, 1 },
	{ "mmap2", 0x900000, 192, 6},
	{ "fstat64", 0x900000, 197, 2},
	{ "fcntl64", 0x900000, 221, 3},
	{ "gettid", 0x900000, 224, 0},
	{ "set_thread_area", 0x900000, 243, 2},
	{ "get_thread_area", 0x900000, 244, 2},
	{ "exit_group", 0x900000, 252, 1},
	{ NULL, 0, 0, 0 }
};

RSyscallItem syscalls_linux_mips[] = {
	{ "syscall", 4000, 1, 1, "i" },
	{ "exit", 4001, 1, 1, "i" },
	{ "fork", 4002, 2, 0, NULL },
	{ "read", 4003, 3, 3, "ipi" },
	{ "write", 4004, 4, 3, "izi" },
	{ "open", 4005, 5, 3, "zxx" },
	{ "close", 4006, 6, 1, "i" },
	{ "waitpid", 4007, 7, 3, "ipx"},
	{ "creat", 4008, 8, 2, "zx" },
	{ "link", 4009, 9, 2, "zz" },
	{ "unlink", 4010, 10, 1, "z" },
	{ "execve", 4011, 11, 3, "zzz" }, // XXX this is char**
	{ "chdir", 4012, 12, 1, "z" },
	{ "time", 4013, 13, 1, "p" },
	{ "mknod", 4014, 14, 1, "zxi" },
	{ "chmod", 4015, 15, 1, "zx" },
	{ "lchown", 4016, 16, 1, "zii" },
	{ "getpid", 4020, 20, 0, NULL},
	{ "setuid", 4023, 23, 1, "i" },
	{ "getuid", 4024, 24, 0, NULL },
	{ "ptrace", 4026, 26, 4 },
	{ "utime", 4030, 30, 2 },
	{ "access", 4033, 33, 2 },
	{ "kill", 4037, 37,2 },
	{ "dup", 4041, 41, 2 },
	{ "brk", 4045, 45, 1 },
	{ "signal", 4048, 48, 2 },
	{ "ioctl", 4054, 54, 3 },
	{ "mmap", 4090, 90, 6 },
	{ "munmap", 4091, 91, 1 },
	{ "socketcall", 4000+102, 102, 2 },
	{ "sigreturn", 4000+119, 119, 1 },
	{ "clone", 4000+120, 120, 4 },
	{ "mprotect", 4000+125, 125, 3},
	{ "rt_sigaction", 4000+174, 174, 3},
	{ "rt_sigprocmask", 4000+175, 175, 3},
	{ "sysctl", 4000+149, 149, 1 },
	{ "mmap2", 4000+192, 192, 6},
	{ "fstat64", 4000+197, 197, 2},
	{ "fcntl64", 4000+221, 221, 3},
	{ "gettid", 4000+224, 224, 0},
	{ "set_thread_area", 4000+243, 243, 2},
	{ "get_thread_area", 4000+244, 244, 2},
	{ "exit_group", 4000+252, 252, 1},
	{ NULL }
};
