/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: config.h,v 1.143.2.4 2005/01/15 21:09:38 amcwilliam Exp $
 */

#ifndef	__config_include__
#define	__config_include__

#include "setup.h"

#define LOWEST_FD	4 /* skip stdin, stdout, stderr, and profiler */

#define HARD_FDLIMIT	(HARD_FDLIMIT_ - 10)
#define MASTER_MAX	(HARD_FDLIMIT - MAX_BUFFER)

#ifdef OS_SUNOS_DBE
#define FD_SETSIZE HARD_FDLIMIT_
#define NOFILE HARD_FDLIMIT_
#endif

/* The following files are explicit for system installs */
#define IRCD_EXE		BIN_DIR "/rageircd"

#define PID_FILE		STATE_DIR "/ircd.pid"
#define STATS_FILE		STATE_DIR "/ircd.stats"
#define ENTROPY_FILE		STATE_DIR "/.ircd.entropy"

/* Log files, explicit too */
#define LOGFILE_DEFAULT		LOG_DIR "/ircd.log"
#define LOGFILE_ERROR		LOG_DIR "/error.log"
#define LOGFILE_KILL		LOG_DIR "/kill.log"
#define LOGFILE_CLIENT		LOG_DIR "/client.log"
#define LOGFILE_SERVER		LOG_DIR "/server.log"
#define LOGFILE_OPER		LOG_DIR "/oper.log"
#define LOGFILE_DEBUG		LOG_DIR "/debug.log"
#define LOGFILE_OVERRIDE	LOG_DIR "/override.log"

/* Unlike everything else these are *RELATIVE* to CONF_DIR */
#define CONFIG_FILE		"ircd.conf"
#define MOTD_FILE		"ircd.motd"
#define OPERMOTD_FILE		"ircd.opermotd"
#define RULES_FILE		"ircd.rules"

/*
 * Service Client Nicknames
 *
 * These are used for the service alias functions, and should be changed
 * according to the services available on your network. These were
 * dynamic configuration options, however, I fail to see why anyone
 * would want to change them anyway.
f */
#define CHANSERV "ChanServ"
#define NICKSERV "NickServ"
#define MEMOSERV "MemoServ"
#define OPERSERV "OperServ"
#define STATSERV "StatServ"
#define HOSTSERV "HostServ"
#define BOTSERV "BotServ"

/*
 * Block Allocator heap sizes. These determine how many of each
 * structure are preallocated.
 */
#define CLIENT_HEAP_SIZE		256	/* aClient */
#define LOCALCLIENT_HEAP_SIZE		128	/* LocalClient */
#define USER_HEAP_SIZE			256	/* anUser */
#define LOCALUSER_HEAP_SIZE		128	/* LocalUser */

#define DLINKNODE_HEAP_SIZE		256	/* dlink_node */
#define SLINK_HEAP_SIZE			64	/* SLink */

#define CHANNEL_HEAP_SIZE		128	/* aChannel */
#define CHANMEMBER_HEAP_SIZE		256	/* chanMember */
#define CHANNELBAN_HEAP_SIZE		128	/* channelBan */

#define THROTTLE_HEAP_SIZE		128	/* throttle */
#define HASHENT_HEAP_SIZE		128	/* hashent */

/*
 * INITIAL_SBUF_SMALL, INITIAL_SBUF_LARGE
 *
 * How many bytes to allocate for small and large shared buffers respectively.
 * Original from bahamut-release was 2mb each, but they've been decreased
 * somewhat, to 512kb each.
 */
#define INITIAL_SBUF_SMALL ((1 << 20) / 2)	/* 512kb */
#define INITIAL_SBUF_LARGE ((1 << 20) / 2)	/* 512kb */

/*
 * INITIAL_SBUF_USER_POOL
 *
 * How many shared buffers to keep alive in the buffer pool. The original
 * used to be 256, a quater of MAXCONNECTIONS. This is also true for rage2,
 * but using a quater of the localClient heap size.
 */
#define INITIAL_SBUF_USER_POOL		(LOCALCLIENT_HEAP_SIZE / 4)

/*
 * Throttle Support
 *
 * THROTTLE_RECORDTIME - length to keep records for each ip (since last connect)
 * THROTTLE_HASHSIZE   - size of the throttle hash table
 *
 * We recommend you do not change these unless it's crutial.
 */
#define THROTTLE_RECORDTIME 1800
#define THROTTLE_HASHSIZE 25147

/*
 * BLOCKHEAP_CLEANUP_FREQ
 *
 * If the block heap allocator is enabled, this is the time in seconds between
 * automatic memory garbage collection, which clean up block heaps to eliminate
 * fragmentation and memory leaks.
 *
 * Default is 3 hrs.
 */
#define BLOCKHEAP_CLEANUP_FREQ (60 * 60) * 3

/*
 * TRY_CONNECTIONS_FREQ
 *
 * The number of seconds between calls to try_connections(), to auto-connect
 * to server links. Don't change this unless you know what you're doing.
 * Doing it too early may cause a lot of nick collisions.
 */
#define TRY_CONNECTIONS_FREQ 60

#include "defs.h"

/*
 * ABORT_ON_MALLOC_FAILURE
 *
 * If defined, ircd will abort (core dump) in the event of memory
 * allocation failure. This will allow for debugging, but results
 * in the server being terminated if system memory is low or non-
 * existant. Not recommended for production servers, only debugging.
 */
#define ABORT_ON_MALLOC_FAILURE

/*
 * INCREASE_SOCK_BUFS
 *
 * If defined, the size of the send and receive socket buffers will be
 * dynamically allocated upon connection. Server buffers will then be
 * increased to 64k. However, client buffers shall remain at 8k.
 */
#define INCREASE_SOCK_BUFS

/*
 * LUSERS_CACHE_TIME
 *
 * Amount of time to wait before re-calculating the lusers count.
 * Saves a considerable amount of CPU per client-connect. The
 * default value is 3 minutes.
 */
#define LUSERS_CACHE_TIME 180

/*
 * ANTI_NICK_FLOOD_CHANGES and ANTI_NICK_FLOOD_TIME
 *
 * These are the parameters for nickname changing flood protection.
 * Provided general::options::anti-nick-flood is enabled, any nickname
 * changes will be blocked if the client in question has performed
 * ANTI_NICK_FLOOD_CHANGES within ANTI_NICK_FLOOD_TIME seconds.
 */
#define ANTI_NICK_FLOOD_CHANGES 4
#define ANTI_NICK_FLOOD_TIME 20

/*
 * MAX_AWAY_COUNT and MAX_AWAY_TIME
 *
 * These provide the parameters for the AWAY flood protection.
 * Provided servinfo::options::anti-away-flood is enabled, any client
 * attempting to do MAX_AWAY_COUNT AWAY message changes within
 * MAX_AWAY_TIME seconds will be ignored.
 */
#define MAX_AWAY_COUNT 5
#define MAX_AWAY_TIME 180

/*
 * ALWAYS_SEND_DURING_SPLIT
 *
 * on a large network, if your server is carrying large amounts of clients,
 * and your server splits from the main network, the amount of allocated
 * dbufs will skyrocket as buffers fill up with QUIT messages. This code
 * attempts to combat this by sending out data whenever possible during a
 * split. - lucas
 */
#define ALWAYS_SEND_DURING_SPLIT

/*
 * CMDLINE_CONFIG
 *
 * Define this to enable the -c command-line option to specify an alternate
 * ircd.conf file.
 */
#define CMDLINE_CONFIG

/*
 * HIDE_SPOOFED_IPS
 *
 * Define this if you want clients with spoofed hosts to have their
 * IP addresses hidden too.
 */
#define HIDE_SPOOFED_IPS

/*
 * HIDDEN_IP
 *
 * This is what hidden and spoofed IP addresses will be replaced with.
 */
#define HIDDEN_IP "255.255.255.255"

/*
 * MAXCONNECTIONS
 *
 * WARNING: Do not change this directly. Change the HARD_FDLIMIT_
 * variable instead.
 *
 * Maximum number of network connections your server will allow.  This
 * should never exceed max. number of open file descrpitors and wont
 * increase this. Should remain LOW as possible. Most sites will
 * usually have under 30 or so connections. A busy hub or server may
 * need this to be as high as 50 or 60. Making it over 100 decreases
 * any performance boost gained from it being low. if you have a lot of
 * server connections, it may be worth splitting the load over 2 or
 * more servers. 1 server = 1 connection, 1 user = 1 connection. This
 * should be at *least* 3: 1 listen port, 1 dns port + 1 client
 */
#define MAXCONNECTIONS HARD_FDLIMIT

/*
 * NICKNAMEHISTORYLENGTH
 *
 * This defines the length of the nickname history.  Each time a user
 * changes nickname or signs off, their old nickname is added to the
 * top of the list.
 *
 * WARNING: This is directly related to the amount of memory ircd will
 * use whilst resident and running - it hardly ever gets swapped to
 * disk! Memory will be preallocated for the entire whowas array when
 * ircd is started.
 */
#define NICKNAMEHISTORYLENGTH 1024

/*
 * TIMESEC - Time interval to wait and if no messages have been
 * received, then check for PINGFREQUENCY and CONNECTFREQUENCY
 */
#define TIMESEC 5

/*
 * DEFAULT_MAX_ACCEPT
 *
 * Default value for max_accept ircd.conf variable, defining how many
 * users a single client can have on his or her /accept list.
 */
#define DEFAULT_MAX_ACCEPT 10

/*
 * DEFAULT_MAX_DCCALLOW
 *
 * Default value for max_dccallow ircd.conf variable, defining how
 * many users a single client can have on his or her /dccallow list.
 */
#define DEFAULT_MAX_DCCALLOW 5

/*
 * DEFAULT_MAX_BANS
 *
 * The default value for the max_bans variable in ircd.conf, defining
 * how many bans, excepts and invex' can be on each list at any one time.
 */
#define DEFAULT_MAX_BANS 45

/*
 * DEFAULT_MAX_WATCH
 *
 * Default number of entries allowed on a single users WATCH list.
 * Over-written using the max_watch variable in ircd.conf.
 */
#define DEFAULT_MAX_WATCH 128

/*
 * DEFAULT_MAX_KILLS
 *
 * Default value for max_kills variable in ircd.conf. Specifies the
 * maximum number of targets allowed in a single /KILL command.
 */
#define DEFAULT_MAX_KILLS 20

/*
 * DEFAULT_MAX_TARGETS
 *
 * Default value for max_targets variable in ircd.conf. Specifies
 * how many single targets may be specified via a single privmsg.
 *
 * This cannot exceed the HARD_TARGET_LIMIT size in struct.h.
 */
#define DEFAULT_MAX_TARGETS 10

/*
 * DEFAULT_USER_RECVQ_LIMIT
 *
 * This controls the number of bytes the server will allow a user
 * to send to the server without processing before the client is
 * dropped for flooding. Must be >512 bytes.
 */
#define	DEFAULT_USER_RECVQ_LIMIT 2650

/*
 * DEFAULT_COMPRESSION_LEVEL
 *
 * Default level of compression to use for compressed server<->server
 * links. Range from 0 to 9, 0 being disabled. The higher the level,
 * the more compression is performed, but the more cpu time is used.
 */
#define DEFAULT_COMPRESSION_LEVEL 6

/*
 * DEFAULT_TS_DELTA_MAX and DEFAULT_TS_DELTA_WARN
 *
 * Default values for general::ts_delta_max and ts_delta_warn. If the
 * difference between our system time, and the time of a remote link
 * exceeds ts_delta_max, drop the link. If it exceeds ts_delta_warn,
 * send a routing notice.
 */
#define DEFAULT_TS_DELTA_MAX 120
#define DEFAULT_TS_DELTA_WARN 60

/*
 * DEFAULT_NETWORK_NAME, DEFAULT_NETWORK_NAME_005
 *
 * Default IRC network names, should none be specified in ircd.conf. Note
 * the latter should be identical to the former, but replace spaces with
 * a dash or underscore. (eg, "IRC Network" becomes "IRC-Network".)
 */
#define DEFAULT_NETWORK_NAME "IRC"
#define DEFAULT_NETWORK_NAME_005 "IRC"

/*
 * DEFAULT_KLINE_ADDRESS
 *
 * Default kline address to use, should none be specified in ircd.conf.
 * This will be used for both local and remote bans (ie, network-wide
 * and local-only).
 */
#define DEFAULT_KLINE_ADDRESS "admin@poorly.configured.server"

/*
 * DEFAULT_KLINE_TIME
 *
 * Defines the default value of the default_kline_time variable in
 * ircd.conf. If the variable is set (i.e. not 0), but lower than 60
 * seconds (1 minute), this default shall be used.
 */
#define DEFAULT_KLINE_TIME 1800 /* 30 minutes */

/*
 * LOCAL_BAN, LOCAL_BANNED, NETWORK_BAN, NETWORK_BANNED, DEFAULT_REASON
 *
 * Pretty self explanitory: these are shown in server notices, and
 * to recipients of the "you are banned" message.
 */
#define LOCAL_BAN	"k-line"
#define LOCAL_BANNED	"k-lined"
#define NETWORK_BAN	"autokill"
#define NETWORK_BANNED	"autokilled"
#define DEFAULT_REASON	"No reason"

/*
 * DEFAULT_USER_MASK_PREFIX
 *
 * Default string to prefix user masked hostnames, should none be
 * specified in ircd.conf. This is the string that appears before
 * the "-CRC32HEX.isp.com" in user masked hostnames.
 */
#define DEFAULT_USER_MASK_PREFIX "masked"

/*
 * DEFAULT_PINGTIME
 *
 * Default amount of seconds before the server checks internal list
 * to see if any connections that have been inactive for a specified
 * amount of time are still alive.
 */
#define DEFAULT_PINGTIME 120

/*
 * DEFAULT_CHANS_PER_USER
 *
 * Default amount of channels a client is allowed to be in at any
 * one time.
 */
#define DEFAULT_CHANS_PER_USER 10

/*
 * DEFAULT_MAX_CLIENTS
 *
 * Default amount of connections allowed in a class at any one time.
 */
#define DEFAULT_MAX_CLIENTS 256

/*
 * DEFAULT_LINK_DEPTH
 *
 * Default depth of a server link.
 */
#define DEFAULT_LINK_DEPTH 5

/*
 * DEFAULT_CONNAUTH_TIMEOUT
 *
 * Default amount of time, in seconds, to cycle the internal resolver
 * list to expire un-resolved hosts.
 */
#define DEFAULT_CONNAUTH_TIMEOUT 10

/*
 * DEFAULT_PORTNUM
 *
 * This defines the default port number to use in configuration if the
 * specified port is out of range. Range is from 1 to 65535.
 */
#define DEFAULT_PORTNUM 7000

/*
 * DEFAULT_JOIN_PART_TIME and DEFAULT_JOIN_PART_COUNT
 *
 * These define the default values for the anti spambot join/part throttle
 * mechanism. The OPER_SPAM_COUNTDOWN variable defines the frequency at which
 * spambot join/part throttle notices are sent to opers, to limit nagging.
 */
#define DEFAULT_JOIN_PART_TIME 60
#define DEFAULT_JOIN_PART_COUNT 10
#define OPER_SPAM_COUNTDOWN 10

/*
 * HANGONGOODLINK and HANGONGOODLINK
 *
 * Often net breaks for a short time and it's useful to try to 
 * establishing the same connection again faster than DEFAULT_CONNECTFREQ
 * would allow. But, to keep trying on bad connection, we require that 
 * connection has been open for certain minimum time (HANGONGOODLINK) and 
 * we give the net few seconds to steady (HANGONRETRYDELAY). This latter 
 * has to be long enough that the other end of the connection has time to 
 * notice it broke too.
 */
#define HANGONRETRYDELAY 60
#define HANGONGOODLINK 3600

/*
 * CONNECTTIMEOUT
 *
 * Number of seconds to wait for a connect(2) call to complete.
 *
 * NOTE: This must be at LEAST 10. When a client connects, it has
 * CONNECTTIMEOUT - 10 seconds for its host to respond to an identd
 * lookup and for a DNS answer to be retrieved.
 */
#define	CONNECTTIMEOUT	30

/*
 * KILLCHASETIMELIMIT
 *
 * Max time from the nickname change that still causes KILL automaticly 
 * to switch for the current nick of that user.
 */
#define KILLCHASETIMELIMIT 90

/*
 * FLUD - CTCP Flood Detection and Protection
 * 
 * This enables server CTCP flood detection and protection for local
 * clients. It works well against fludnets and flood clones.  The
 * effect of this code on server CPU and memory usage is minimal,
 * however you may not wish to take the risk, or be fundamentally
 * opposed to checking the contents of PRIVMSG's (though no privacy is
 * breached).  This code is not useful for routing only servers (ie,
 * HUB's with little or no local client base), and the hybrid team
 * strongly recommends that you do not use FLUD with HUB. The following
 * default thresholds may be tweaked, but these seem to work well.
 */
#define FLUD

#ifdef FLUD
#define FLUD_NUM 4	/* Number of flud messages to trip alarm */
#define FLUD_TIME 3	/* Seconds in which FLUD_NUM msgs must occur */
#define FLUD_BLOCK 15	/* Seconds to block fluds */
#endif

/*
 * If the OS has SOMAXCONN use that value, otherwise Use the value in
 * HYBRID_SOMAXCONN for the listen(); backlog try 5 or 25. 5 for AIX
 * and SUNOS, 25 should work better for other OS's
 */
#define HYBRID_SOMAXCONN 25

/* DO NOT EDIT ANYTHING BELOW THIS LINE! */

#ifdef INCREASE_SOCK_BUFS
#define CLIENT_BUFFER_SIZE 4096
#define SEND_BUFFER_SIZE 2048
#endif

#ifdef DEBUGMODE
extern void debug(int level, char *pattern, ...);
#define Debug(x) debug x
#define LOGFILE LOGFILE_DEFAULT
#else
#define Debug(x)
#define LOGFILE "/dev/null"
#endif

#define CONFIG_H_BLUEMOON

#endif /* __config_include__ */
