/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: find.h,v 1.9.2.1 2004/12/07 03:04:36 pneumatus Exp $
 */

#ifndef	__find_include__
#define __find_include__

#define find_server(a, b) hash_find_server(a, b)
#define find_client(a, b) hash_find_client(a, b)

#define find_target(x) (x ? (*x == '!' ? find_by_base64_id(x) : hash_find_client(x, NULL)) : NULL)
#define find_target_chasing(z, x, q) (x ? (*x == '!' ? find_by_base64_id(x) : find_chasing(z, x, NULL, q)) : NULL)
#define find_target_from(x, c) (x ? ((IsServer(c) && *x == '!') ? find_by_base64_id(x) : hash_find_client(x, NULL)) : NULL)

static inline aClient *find_person(char *name, aClient *cptr)
{
	aClient *acptr = find_client(name, cptr);
	return acptr != NULL ? (IsClient(acptr) ? acptr : cptr) : cptr;
}

static inline aClient *find_person_target(char *name)
{
	aClient *acptr = find_target(name);
	return acptr != NULL ? (IsClient(acptr) ? acptr : NULL) : NULL;
}

static inline aClient *find_server_target(char *name)
{
	aClient *acptr = find_target(name);
	return acptr != NULL ? (IsServer(acptr) ? acptr : NULL) : NULL;
}

static inline aClient *find_person_on_server(char *name, char *server)
{
	aClient *acptr = find_client(name, NULL);

	if (acptr == NULL || !IsClient(acptr)) {
		return NULL;
	}
	if (!mycmp(server, acptr->uplink->name)) {
		return acptr;
	}
	return NULL;
}

#endif /* __find_include__ */
