/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: send.h,v 1.38.2.2 2004/12/13 23:33:05 amcwilliam Exp $
 */

#ifndef __send_include__
#define __send_include__

#include "msg.h"
#include "xmode.h"
#include "ssl.h"
#include <stdarg.h>

extern void send_queued_buffers();

/* FIXME--
  We are eventually going to try and phase some of these
  less-common macros out, as they're pretty crap tbh.
*/

extern void sendto_one_client(aClient *, aClient *, msg_ptr *, char *, ...);
extern void sendto_one_client_real(aClient *, aClient *, aClient *, msg_ptr *, char *, ...);
extern void sendto_one_client_prefixed(aClient *, aClient *, msg_ptr *, char *, ...);
extern void sendto_one_client_nopostfix(aClient *, aClient *, msg_ptr *, char *, ...);
extern void sendto_one_client_onserver(aClient *, aClient *, msg_ptr *, char *, ...);
extern void sendto_one_client_numeric(aClient *, aClient *, char *, int, ...);

extern void sendto_match_msg_butone(aClient *, aClient *, char *, int, msg_ptr *, char *, ...);
extern void sendto_serv_msg_butone(aClient *, aClient *, msg_ptr *, char *, ...);
extern void sendto_serv_capab_msg_butone(aClient *, aClient *, unsigned int, unsigned int, msg_ptr *, char *, ...);
extern void sendto_serv_kill_msg_butone(aClient *, aClient *, aClient *, char *, ...);
extern void sendto_channel_msg_butone(aClient *, aClient *, aChannel *, unsigned int, msg_ptr *, char *, ...);
extern void sendto_channel_local_msg_butone(aClient *, aClient *, aChannel *, unsigned int, msg_ptr *, char *, ...);
extern void sendto_channel_local_msg_common(aClient *, msg_ptr *, char *, ...);

extern void sendto_mode(unsigned long, char *, char *, ...);
extern void sendto_realops(char *, ...);
extern void sendto_realops_lev(int, char *, ...);

extern void send_quit_to_common_channels(aClient *, char *);
extern void send_part_to_common_channels(aClient *, char *);
extern void send_wallops(aClient *, char *, ...);

#define send_me_notice(to, pat, args...)	sendto_one_client(to, &me, &CMD_NOTICE, pat, args)
#define send_me_noticeNA(to, pat)		sendto_one_client(to, &me, &CMD_NOTICE, pat)

#define send_me_numeric(to, num, args...)	sendto_one_client_numeric(to, &me, NULL, num, args)
#define send_me_numericNA(to, num)		sendto_one_client_numeric(to, &me, NULL, num)

#define send_me_numeric_buf(to, pat, num, args...) sendto_one_client_numeric(to, &me, pat, num, args)
#define send_me_numeric_bufNA(to, pat, num)	sendto_one_client_numeric(to, &me, pat, num)

#define send_me_debug(to, pat, args...)		sendto_one_client_numeric(to, &me, pat, RPL_STATSDEBUG, args)
#define send_me_debugNA(to, pat)		sendto_one_client_numeric(to, &me, pat, RPL_STATSDEBUG)

#define send_chatops(pat, args...)	sendto_mode(UMODE_CHATOPS, "ChatOps", pat, args)
#define send_globops(pat, args...)	sendto_mode(UMODE_GLOBOPS, "Global", pat, args)
#define send_locops(pat, args...)	sendto_mode(UMODE_OPER, "LocOps", pat, args)
#define send_gnotice(pat, args...)	sendto_mode(UMODE_RSTAFF, "Routing", pat, args)

#ifdef USE_OPENSSL
#define ircsend(c, p, s)	(IsSecure(c)) ? \
					safe_SSL_write((c), (p), (s)) : send((c)->localClient->fd, (p), (s), 0)
#define ircrecv(c, p, s)	(IsSecure(c)) ? \
					safe_SSL_read((c), (p), (s)) : recv((c)->localClient->fd, (p), (s), 0)
#else
#define ircsend(c, p, s)	send((c)->localClient->fd, (p), (s), 0)
#define ircrecv(c, p, s)	recv((c)->localClient->fd, (p), (s), 0)
#endif

#endif /* __send_include__ */
