/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_akill.c,v 1.36.2.2 2005/01/15 23:53:33 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "user_ban.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_akill) = {
	"m_akill",
	"/AKILL command",
	6, "$Revision: 1.36.2.2 $"
};

int MOD_LOAD(m_akill)()
{
	if (register_command(&MOD_HEADER(m_akill), &CMD_AKILL, m_akill) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_akill)()
{
	return MOD_SUCCESS;
}

/*
 * m_akill
 *	parv[0] = sender prefix
 *	parv[1] = host
 *	parv[2] = user
 *	parv[3] = duration
 *	parv[4] = akiller
 *	parv[5] = time set
 *	parv[6] = reason
 */
int m_akill(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char *user, *host, *akiller, *reason, buf[BUFSIZE];
	time_t timeset = 0;
	int duration = 0;
	userBan *uban;
	dlink_node *node, *next = NULL;
	aClient*acptr;

	if (!IsServer(sptr) || (parc < 6)) {
		return 0;
	}
	if (!IsULine(sptr)) {
		sendto_serv_msg_butone(NULL, &me, &CMD_GLOBOPS, ":Non-ULined server "
			"%s is trying to AKILL!", parv[0]);
		send_globops("Non-ULined server %s is tring to AKILL!", parv[0]);
		return 0;
	}

	user = parv[2];
	host = parv[1];
	akiller = parv[4];

	if (!(duration = atoi(parv[3]))) {
		duration = 86400; /* Hold the akill for a day */
	}

	timeset = strtol(parv[5], NULL, 10);
	if ((timeset + duration) <= timeofday) {
		return 0;
	}

	reason = !BadPtr(parv[6]) ? parv[6] : "no reason";
	if (strlen(reason) > 250) {
		reason[250] = '\0';
	}

	ircsnprintf(buf, BUFSIZE - 1, "%s (%s)", reason, smalldate((time_t)timeset));

	if ((uban = make_userban(user, host, reason, duration)) == NULL) {
		ircdlog(LOG_ERROR, "make_userban(%s,%s,%s,%d) failed in AKILL", user, host, reason, duration);
		return 0;
	}

	if (find_userban_exact(uban, 0) == NULL) {
		uban->flags |= (BAN_NETWORK|BAN_TEMPORARY);
		add_userban(uban);
	}
	else {
		userban_free(uban);
	}

	sendto_serv_msg_butone(cptr, sptr, &CMD_AKILL, "%s %s %d %s %ld :%s", host, user, duration,
		akiller, timeset, reason);

	DLINK_FOREACH_SAFE_DATA(lclient_list.head, node, next, acptr, aClient) {
		if (!IsKlineExempt(acptr) && user_match_ban(acptr, uban)) {
			if (uban->flags & (UBAN_CIDRBIG|UBAN_CIDR|UBAN_IPV4)) {
				exit_client_zap(acptr, acptr, uban);
			}
			else {
				exit_client_kill(acptr, acptr, uban);
			}
		}
	}

	return 0;
}
