/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_away.c,v 1.28.2.2 2005/01/15 23:53:31 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_away) = {
	"m_away",
	"/AWAY command",
	6, "$Revision: 1.28.2.2 $"
};

int MOD_LOAD(m_away)()
{
	if (register_command(&MOD_HEADER(m_away), &CMD_AWAY, m_away) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_away)()
{
	return MOD_SUCCESS;
}

/*
 * m_away
 *	parv[0] = sender prefix
 *	parv[1] = reason
 */
int m_away(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char *reason = (parc > 1 && *parv[1] != '\0') ? parv[1] : NULL;

	if (sptr->user == NULL) {
		return 0;
	}
	if (FloodConfig.anti_away_flood && MyClient(sptr)) {
		if ((sptr->localUser->last_away_change + MAX_AWAY_TIME) < timeofday) {
			sptr->localUser->away_changes = 0;
		}
		sptr->localUser->last_away_change = timeofday;
		sptr->localUser->away_changes++;
	}
	if (parc < 2 || reason == NULL) {
		if (sptr->user->away != NULL) {
			MyFree(sptr->user->away);
			sptr->user->away = NULL;
			sendto_serv_msg_butone(cptr, sptr, &CMD_AWAY, "");
		}
		if (MyClient(sptr)) {
			send_me_numericNA(sptr, RPL_UNAWAY);
		}
		return 0;
	}
	if (FloodConfig.anti_away_flood && MyClient(sptr)
	  && (sptr->localUser->away_changes > MAX_AWAY_COUNT) && !HasMode(sptr, UMODE_OPER)) {
		send_me_numericNA(sptr, ERR_TOOMANYAWAY);
		return 0;
	}
	if (strlen(reason) > TOPICLEN) {
		reason[TOPICLEN] = '\0';
	}

	sendto_serv_msg_butone(cptr, sptr, &CMD_AWAY, ":%s", reason);
	if (sptr->user->away != NULL) {
		MyFree(sptr->user->away);
	}
	DupString(sptr->user->away, reason);

	if (MyClient(sptr)) {
		send_me_numericNA(sptr, RPL_NOWAWAY);
	}
	return 0;
}
