/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_die.c,v 1.32.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_die) = {
	"m_die",
	"/DIE command",
	6, "$Revision: 1.32.2.2 $"
};

int MOD_LOAD(m_die)()
{
	if (register_command(&MOD_HEADER(m_die), &CMD_DIE, m_die) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_die)()
{
	return MOD_SUCCESS;
}

/*
 * m_die
 *	parv[0] = sender prefix
 *	parv[1] = password
 */
int m_die(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	dlink_node *node;
	aClient *acptr = NULL;
	char *inpath;

	if (!OPHasFlag(sptr, OFLAG_DIE)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}

	DLINK_FOREACH_DATA(lclient_list.head, node, acptr, aClient) {
		send_me_notice(acptr, ":Server terminating by request of %s (%s@%s).",
			sptr->name, sptr->username, MaskedHost(sptr));
	}

	inpath = get_client_name(sptr, HIDE_IP);
	DLINK_FOREACH_DATA(lserver_list.head, node, acptr, aClient) {
		sendto_one_client_nopostfix(acptr, NULL, &CMD_ERROR, ":Terminated by %s",
			inpath);
	}

	ircdlog(LOG_DEFAULT, "Server terminating by request of %s", sptr->name, inpath);
	server_die();

	return 0;
}
