/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_globops.c,v 1.19.2.2 2005/01/15 23:53:34 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_globops) = {
	"m_globops",
	"/GLOBOPS command",
	6, "$Revision: 1.19.2.2 $"
};

int MOD_LOAD(m_globops)()
{
	if (register_command(&MOD_HEADER(m_globops), &CMD_GLOBOPS, m_globops) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_globops)()
{
	return MOD_SUCCESS;
}

/*
 * m_globops
 *	parv[0] = sender prefix
 *	parv[1] = message
 */
int m_globops(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	if (MyClient(sptr) && !OPHasFlag(sptr, OFLAG_GLOBOPS) && !IsULine(sptr)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 2 || BadPtr(parv[1])) {
		if (MyClient(sptr)) {
			send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "GLOBOPS");
		}
		return 0;
	}
	if (strlen(parv[1]) > TOPICLEN) {
		parv[1][TOPICLEN] = '\0';
	}

	send_globops("from %s: %s", parv[0], parv[1]);
	sendto_serv_msg_butone(cptr, sptr, &CMD_GLOBOPS, ":%s", parv[1]);
	return 0;
}
