/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_info.c,v 1.27.2.2 2005/01/15 23:53:34 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_info) = {
	"m_info",
	"/INFO command",
	6, "$Revision: 1.27.2.2 $"
};

int MOD_LOAD(m_info)()
{
	if (register_command(&MOD_HEADER(m_info), &CMD_INFO, m_info) == NULL) {
		return MOD_FAILURE;
	}
 	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_info)()
{
	return MOD_SUCCESS;
}

/*
 * m_info
 *	parv[0] = sender prefix
 *	parv[1] = servername
 */
int m_info(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	char **text;
	static time_t last_used = 0L;

	if (use_or_deliver(cptr, sptr, &CMD_INFO, ":%s", 1, parc, parv) != HUNTED_ISME) {
		return 0;
	}
	if (!HasMode(sptr, UMODE_OPER)) {
		if (FloodConfig.pace_wait_simple > 0 && (last_used + FloodConfig.pace_wait_simple > timeofday)) {
			send_me_numericNA(sptr, RPL_LOAD2HI);
			return 0;
		}
		else {
			last_used = timeofday;
		}
		if (GeneralConfig.spy_notices && IsPerson(sptr)) {
			sendto_realops_lev(SPY_LEV, "INFO requested by %s (%s@%s) [%s]", sptr->name,
				sptr->username, MaskedHost(sptr), sptr->user->server);
		}
	}

	for (text = infotext; *text != NULL; text++) {
		send_me_numeric(sptr, RPL_INFO, *text);
	}

	send_me_numeric_buf(sptr, ":Created %s, compile #%s", RPL_INFO, creation, compile_number);
	send_me_numeric_buf(sptr, ":On-line since: %s", RPL_INFO, myctime(me.firsttime));

	send_me_numericNA(sptr, RPL_ENDOFINFO);
	return 0;
}
