/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_ping.c,v 1.20.2.2 2005/01/15 23:53:34 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_ping) = {
	"m_ping",
	"/PING command",
	6, "$Revision: 1.20.2.2 $"
};

int MOD_LOAD(m_ping)()
{
	if (register_command(&MOD_HEADER(m_ping), &CMD_PING, m_ping) == NULL) {
		return MOD_FAILURE;
	}
	MOD_SET_FLAG(&MOD_HEADER(m_ping), MOD_FLAG_PERM);
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_ping)()
{
	return MOD_SUCCESS;
}

/*
 * m_ping
 *	parv[0] = sender prefix
 *	parv[1] = origin
 *	parv[2] = destination
 */
int m_ping(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr;
	char *origin, *destination;

	if (parc < 2 || BadPtr(parv[1])) {
		send_me_numericNA(sptr, ERR_NOORIGIN);
		return 0;
	}

	origin = parv[1];
	destination = parv[2];

	if ((acptr = find_client(origin, NULL)) == NULL) {
		acptr = find_server(origin, NULL);
	}
	if (acptr != NULL && acptr != sptr) {
		origin = cptr->name;
	}

	if (!BadPtr(destination) && mycmp(destination, me.name)) {
		if ((acptr = find_server(destination, NULL)) == NULL) {
			send_me_numeric(sptr, ERR_NOSUCHSERVER, destination);
		}
		else {
			sendto_one_client_nopostfix(acptr, sptr, &CMD_PING, "%s :%s", origin,
				destination);
		}
		return 0;
	}

	sendto_one_client_nopostfix(sptr, &me, &CMD_PONG, "%s :%s", destination ? destination : me.name, origin);
	return 0;
}
