/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_quit.c,v 1.27.2.2 2005/01/15 23:53:32 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_quit) = {
	"m_quit",
	"/QUIT command",
	6, "$Revision: 1.27.2.2 $"
};

int MOD_LOAD(m_quit)()
{
	if (register_command(&MOD_HEADER(m_quit), &CMD_QUIT, m_quit) == NULL) {
		return MOD_FAILURE;
	}
	MOD_SET_FLAG(&MOD_HEADER(m_quit), MOD_FLAG_PERM);
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_quit)()
{
	return MOD_SUCCESS;
}

/*
 * m_quit
 *	parv[0] = sender prefix
 *	parv[1] = comment
 */
int m_quit(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	int validmsg = (parc > 1 && *parv[1] != '\0') ? 1 : 0;
	char comment[TOPICLEN + 1];

	SetNormalExit(sptr);

	if (IsServer(cptr)) {
		return exit_client(cptr, sptr, sptr, validmsg ? parv[1] : cptr->name);
	}

	if (!validmsg || !GeneralConfig.custom_quit_msgs || (!HasMode(sptr, UMODE_OPER)
	  && ((FloodConfig.antispam_quit_msg_time > 0)
	  && (sptr->firsttime + FloodConfig.antispam_quit_msg_time) > timeofday))) {
		return exit_client(cptr, sptr, sptr, "Client Quit");
	}

	if (strlen(parv[1]) > (TOPICLEN - 7)) {
		parv[1][TOPICLEN - 7] = '\0';
	}
	ircsprintf(comment, "Quit: %s", parv[1]);

	return exit_client(cptr, sptr, sptr, comment);
}
