/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_samode.c,v 1.29.2.2 2005/01/15 23:53:33 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

static int (*p_do_chan_mode)(aClient *, aClient *, aChannel *, int, char **, int);

Module MOD_HEADER(m_samode) = {
	"m_samode",
	"/SAMODE command",
	6, "$Revision: 1.29.2.2 $"
};

int MOD_LOAD(m_samode)()
{
	if ((p_do_chan_mode = find_symbol(do_chan_mode, "modules/commands/m_mode.so")) == NULL) {
		ircdlog(LOG_ERROR, "m_samode.so: can't resolve symbol do_chan_mode");
		return MOD_FAILURE;
	}

	if (register_command(&MOD_HEADER(m_samode), &CMD_SAMODE, m_samode) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_samode)()
{
	return MOD_SUCCESS;
}

/*
 * m_samode
 *	parv[0] = sender prefix
 *	parv[1] = channel
 *	parv[2] = modes
 */
int m_samode(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aChannel *chptr;

	if (!HasMode(sptr, UMODE_SADMIN)) {
		send_me_numericNA(sptr, ERR_NOPRIVILEGES);
		return 0;
	}
	if (parc < 3) {
		send_me_numeric(sptr, ERR_NEEDMOREPARAMS, "SAMODE");
		return 0;
	}
	if ((chptr = find_channel(parv[1], NULL)) == NULL) {
		send_me_numeric(sptr, ERR_NOSUCHCHANNEL, parv[1]);
		return 0;
	}

	if ((*p_do_chan_mode)(cptr, &me, chptr, parc - 2, parv + 2, CPRIV_SADMIN) > 0
	  && MyClient(sptr)) {
		sendto_realops("%s used SAMODE %s (%s%s%s)", sptr->name, chptr->chname,
			modebuf, !BadPtr(parabuf) ? " " : "", !BadPtr(parabuf) ? parabuf : "");
		sendto_serv_msg_butone(NULL, &me, &CMD_GLOBOPS, ":%s used SAMODE %s (%s%s%s)",
			sptr->name, chptr->chname, modebuf, !BadPtr(parabuf) ? " " : "",
			!BadPtr(parabuf) ? parabuf : "");
		ircdlog(LOG_OVERRIDE, "%s used SAMODE %s (%s %s)", get_client_name(sptr, FALSE),
			chptr->chname, modebuf, !BadPtr(parabuf) ? parabuf : "<NOPARAS>");
	}
	return 0;
}
