/*
 * RageIRCd: an advanced Internet Relay Chat daemon (ircd).
 * (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
 *
 * This software is free, licensed under the General Public License.
 * Please refer to doc/LICENSE and doc/README for further details.
 *
 * $Id: m_svsnick.c,v 1.25.2.2 2005/01/15 23:53:31 amcwilliam Exp $
 */

#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "xmode.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

Module MOD_HEADER(m_svsnick) = {
	"m_svsnick",
	"/SVSNICK command",
	6, "$Revision: 1.25.2.2 $"
};

int MOD_LOAD(m_svsnick)()
{
	if (register_command(&MOD_HEADER(m_svsnick), &CMD_SVSNICK, m_svsnick) == NULL) {
		return MOD_FAILURE;
	}
	return MOD_SUCCESS;
}

int MOD_UNLOAD(m_svsnick)()
{
	return MOD_SUCCESS;
}

static unsigned long my_rand()
{
	static unsigned long s = 0, t = 0, k = 12345678;
	int i;

	if (!s && !t) {
		s = (unsigned long)getpid();
		t = (unsigned long)timeofday;
	}

	for (i = 0; i < 12; i++) {
		s = (((s ^ t) << (t & 31)) | ((s ^ t) >> (31 - (t & 31)))) + k;
		k += s + t;
		t = (((t ^ s) << (s & 31)) | ((t ^ s) >> (31 - (s & 31)))) + k;
		k += s + t;
	}

	return s;
}

/*
 * m_svsnick
 *	parv[0] = sender prefix
 *	parv[1] = old nickname/suid
 *	parv[2] = new nickname
 *	parv[3] = TS
 */
int m_svsnick(aClient *cptr, aClient *sptr, int parc, char *parv[])
{
	aClient *acptr, *ocptr;
	char newnick[NICKLEN + 1];

	if (!IsULine(sptr) || parc < 4 || strlen(parv[2]) > NICKLEN) {
		return 0;
	}
	if (use_or_deliver(cptr, sptr, &CMD_SVSNICK, "%s %s :%s", 1, parc, parv) != HUNTED_ISME) {
		return 0;
	}
	if ((acptr = find_person_target(parv[1])) == NULL) {
		return 0;
	}

	strncpyzt(newnick, parv[2], NICKLEN+1);
	if ((ocptr = find_client(newnick, NULL)) != NULL) {
		int cnt = 0, rand_num = 0;

		do {
			rand_num = my_rand() % 99999;
			ircsnprintf(newnick, NICKLEN, "%s-%d", parv[2], rand_num);
		} while ((ocptr = find_client(newnick, NULL)) != NULL && (++cnt < 10));

		if (ocptr != NULL) {
			if (IsUnknown(ocptr)) {
				return exit_client(ocptr, ocptr, &me, "SVSNICK Override");
			}
			else {
				return exit_client(acptr, acptr, &me, "SVSNICK Collide");
			}
		}
	}

	if (HasMode(acptr, UMODE_REGNICK)) {
		unsigned long old;
		char mbuf[BUFSIZE];

		old = acptr->umode;
		DelMode(acptr, UMODE_REGNICK);

		send_umode(acptr, acptr, old, ALL_UMODES, mbuf);
	}

	acptr->tsinfo = acptr->localUser->last_nick_change = atoi(parv[3]);

	sendto_channel_local_msg_common(acptr, &CMD_NICK, ":%s", newnick);
	add_history(acptr, 1);
	sendto_serv_msg_butone(NULL, acptr, &CMD_NICK, "%s %ld", newnick, acptr->tsinfo);

	if (*acptr->name != '\0') {
		del_from_client_hash_table(acptr->name, acptr);
	}
	strcpy(acptr->name, newnick);
	add_to_client_hash_table(newnick, acptr);

	return 0;
}
