#!/bin/sh
#
# RageIRCd: an advanced Internet Relay Chat daemon (ircd).
# (C) 2000-2005 the RageIRCd Development Team, all rights reserved.
#
# This software is free, licensed under the General Public License.
# Please refer to doc/LICENSE and doc/README for further details.
#
# $Id: static_modules.c.SH,v 1.3.2.10 2005/03/02 00:53:51 pneumatus Exp $
#

printf "Generating static modules wrapper... "

MODS="`for m in $*; do basename $m .c; done`"

cat >static_modules.c<<__EOF__
/* Automatically generated by static_modules.c.SH. */

#include "setup.h"
#include "config.h"
#include "struct.h"
#include "common.h"
#include "sys.h"
#include "numeric.h"
#include "msg.h"
#include "channel.h"
#include "h.h"
#include "memory.h"
#include "modules.h"
#include "dlink.h"
#include "setup.h"
#include <time.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>

void static_modules_load(dlink_list *);

__EOF__

for m in $MODS; do
	echo "extern Module ${m}_header;" >> static_modules.c
	echo "extern int ${m}_load();" >> static_modules.c
done

cat >>static_modules.c<<__EOF__

typedef struct _static_mod_info {
	Module *header;
	int (*load)();
} static_mod_info;

static_mod_info static_mod_table[] = {
__EOF__

for m in $MODS; do
	echo "{ &${m}_header, ${m}_load }," >> static_modules.c
done

cat >>static_modules.c<<__EOF__
{ NULL, NULL }
};

void static_modules_load(dlink_list *my_mod_list)
{
	static_mod_info *m_ptr;
	char tmp[BUFSIZE];
	
	for (m_ptr = static_mod_table; m_ptr->header != NULL; m_ptr++) {
		if ((*m_ptr->load)() == MOD_FAILURE) {
			ircdlog(LOG_ERROR, "Cannot load module %s: mod load failure", m_ptr->header->name);
		}
		else {
			ircsnprintf(tmp, BUFSIZE, "%s.so", m_ptr->header->name);
			DupString(m_ptr->header->filename, tmp);
			dlink_add(my_mod_list, m_ptr->header);
		}
	}
}

__EOF__

printf "done.\n"
