/*
 * Demonstrate the use of goto, call and return. This machine expects either a
 * lower case char or a digit as a command then a space followed by the command
 * arg. If the command is an char, then the arg must be an a string of chars.
 * If the command is a digit, then the arg must be a string of digits.
 */

#include <iostream>
#include <malloc.h>
#include <stdio.h>

using namespace std;


%% GotoCallRet
	struct {
		fstack[32];
		char comm;
	};

	# Error machine, consumes to end of 
	# line, then starts the main line over.
	garble_line := (
		(any-'\n')*'\n'
	) >{cout << "error: garbling line" << endl;} @{fgoto main;};

	# Look for a string of alphas or of digits, 
	# on anything else, hold the character and return.
	alp_comm := alpha+ $!{fhold;fret;};
	dig_comm := digit+ $!{fhold;fret;};

	# Choose which to machine to call into based on the command.
	action comm_arg {
		if ( comm >= 'a' )
			fcall alp_comm;
		else 
			fcall dig_comm;
	}

	# Specifies command string. Note that the arg is left out.
	command = (
		[a-z0-9] @{comm = fc;} ' ' @comm_arg '\n'
	) @{cout << "correct command" << endl;};

	# Any number of commands. If there is an 
	# error anywhere, garble the line.
	main := command* $!{fhold;fgoto garble_line;};
%%

#define BUFSIZE 1024

int main()
{
	char buf[BUFSIZE];

	GotoCallRet gcr;
	gcr.init();
	while ( fgets( buf, sizeof(buf), stdin ) != 0 ) {
		gcr.execute( buf, strlen(buf) );
	}
	if ( gcr.finish() <= 0 )
		cerr << "gotocallret: error: parsing input" << endl;
	return 0;
}
