/*
 *  Copyright 2001-2004 Adrian Thurston <adriant@ragel.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _FSMCODEGEN_H
#define _FSMCODEGEN_H

#include <iostream>

/* Forwards. */
struct RedFsmAp;
struct ParseData;
struct Action;
struct InlineBlock;
struct NameInst;

/*
 * class FsmCodeGen
 */
class FsmCodeGen
{
public:
	FsmCodeGen( char *fsmName, ParseData *parseData, 
			RedFsmAp *redFsm, std::ostream &out );
	virtual ~FsmCodeGen() {}

	virtual void writeOutHeader() = 0;
	virtual void writeOutCode() = 0;
	
	/* Gather various info on the machine. */
	void findFinalActionRefs();
	void analyzeMachine();
	
	void startCodeGen();
	void endCodeGen();

protected:
	std::ostream &FSM_NAME();
	virtual std::ostream &STACK( int size ) = 0;
	std::ostream &USER_STRUCT( char *data );
	std::ostream &STRUCT_DATA();
	std::ostream &USER_INIT( InlineBlock *ilBlock );
	std::ostream &INIT_CODE();
	std::ostream &START_STATE_ID();
	std::ostream &ACTIONS_ARRAY();
	std::ostream &ALPH_TYPE();
	std::ostream &EL_TYPE();
	std::ostream &GET_KEY();
	std::ostream &TABS( int level );
	std::ostream &KEY( long key );
	virtual std::ostream &CALL( NameInst *name, int targState, bool inFinish ) = 0;
	virtual std::ostream &GOTO( NameInst *name, bool inFinish ) = 0;
	virtual std::ostream &RET( bool inFinish ) = 0;
	virtual std::ostream &CURS( bool inFinish ) = 0;
	virtual std::ostream &TARGS( bool inFinish, int targState ) = 0;
	virtual std::ostream &GET_STATE( NameInst *name, bool inFinish ) = 0;
	virtual std::ostream &CALLE( char *stateExpr, int targState, bool inFinish ) = 0;
	virtual std::ostream &GOTOE( char *stateExpr, bool inFinish ) = 0;
	virtual std::ostream &NEXT( NameInst *name, bool inFinish ) = 0;
	virtual std::ostream &NEXTE( char *stateExpr, bool inFinish ) = 0;
	std::ostream &ACTION( Action *action, int targState, bool inFinish );
	std::ostream &LDIR_PATH( char *path );

	bool anyActions();
	bool anyEofActions()            { return bAnyEofActions; }
	bool anyActionCalls()           { return bAnyActionCalls; }
	bool anyActionRets()            { return bAnyActionRets; }
	bool anyRegActionRets()         { return bAnyRegActionRets; }
	bool anyRegActionByValControl() { return bAnyRegActionByValControl; }
	bool anyRegNextStmt()           { return bAnyRegNextStmt; }
	bool anyRegCurStateRef()        { return bAnyRegCurStateRef; }
	bool anyEofActionControl()      { return bAnyEofActionControl; }
	bool anyEofActionCharRef()      { return bAnyEofActionCharRef; }
	bool anyEofActionHold()         { return bAnyEofActionHold; }

	/* Set up labelNeeded flag for each state. Differs for each goto style so
	 * is virtual. */
	virtual void setLabelsNeeded() {}

	/* Are there any regular transition functions, any out transition functions. */
	char *fsmName;
	ParseData *parseData;
	RedFsmAp *redFsm;
	std::ostream &out;

	bool bAnyEofActions;
	bool bAnyActionCalls;
	bool bAnyActionRets;
	bool bAnyRegActionRets;
	bool bAnyRegActionByValControl;
	bool bAnyRegNextStmt;
	bool bAnyRegCurStateRef;
	bool bAnyEofActionControl;
	bool bAnyEofActionCharRef;
	bool bAnyEofActionHold;
};

#endif /* _FSMCODEGEN_H */
