/*
 *  Copyright 2001-2003 Adrian Thurston <adriant@ragel.ca>
 */

/*  This file is part of Ragel.
 *
 *  Ragel is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 * 
 *  Ragel is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with Ragel; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 */

#ifndef _RAGEL_H
#define _RAGEL_H

#include <stdio.h>
#include <iostream>
#include <fstream>
#include "avltree.h"
#include "config.h"

#define PROGNAME "ragel"

/* To what degree are machine minimized. */
enum MinimizeLevel {
	MinimizeNone,
	MinimizeApprox,
	MinimizeStable,
	MinimizePartition1,
	MinimizePartition2
};

/* Target language. */
enum OutputFormat
{
	OutCCode,
	OutCppCode,
	OutGraphvizDot,
	OutPrint,
	OutDump
};

/* Target output style. */
enum CodeStyleEnum
{
	GenTables,
	GenFTables,
	GenGoto,
	GenFGoto,
	GenIpGoto
};

/* Filter on the output stream that keeps track of the number of lines
 * output. */
class output_filter : public std::filebuf
{
public:
	output_filter() : line(1) { }

	virtual int sync();
	virtual std::streamsize xsputn(const char* s, std::streamsize n);

	int line;
};
	
extern OutputFormat outputFormat;
extern CodeStyleEnum codeStyle;

extern FILE *yyin;

/* IO filenames and stream. */
extern char *inputFile;
extern char *outputFile;
extern std::ostream *outStream;
extern output_filter *outFilter;

/* Options. */
extern bool minimizeEveryOp;
extern MinimizeLevel minimizeLevel;
extern char *machineSpec, *machineName;
extern bool machineSpecFound;
extern bool graphvizDone;

void yyerror( char *error );
int yylex();
int yyparse();

extern int gblErrorCount;
extern char machineMain[];

/* Error reporting. */
struct BISON_YYLTYPE;
struct InputLoc;
std::ostream &error();
std::ostream &error( const BISON_YYLTYPE &loc ); 
std::ostream &error( const InputLoc &loc ); 
std::ostream &error( int first_line, int first_column );
std::ostream &warning( ); 
std::ostream &warning( const InputLoc &loc ); 
std::ostream &warning( int first_line, int first_column );

#endif /* _RAGEL_H */
